/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import org.apache.felix.log.Log;
import org.apache.felix.log.LogReaderServiceFactory;
import org.apache.felix.log.LogServiceFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

public final class Activator
implements BundleActivator {
    private static final String MAX_SIZE_PROPERTY = "org.apache.felix.log.maxSize";
    private static final int DEFAULT_MAX_SIZE = 100;
    private static final String STORE_DEBUG_PROPERTY = "org.apache.felix.log.storeDebug";
    private static final boolean DEFAULT_STORE_DEBUG = false;
    private Log m_log;

    private static int getMaxSize(BundleContext context) {
        int maxSize = 100;
        String maxSizePropValue = context.getProperty(MAX_SIZE_PROPERTY);
        if (maxSizePropValue != null) {
            try {
                maxSize = Integer.parseInt(maxSizePropValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return maxSize;
    }

    private static boolean getStoreDebug(BundleContext context) {
        boolean storeDebug = false;
        String storeDebugPropValue = context.getProperty(STORE_DEBUG_PROPERTY);
        if (storeDebugPropValue != null) {
            storeDebug = Boolean.valueOf(storeDebugPropValue);
        }
        return storeDebug;
    }

    public void start(BundleContext context) throws Exception {
        this.m_log = new Log(Activator.getMaxSize(context), Activator.getStoreDebug(context));
        context.addBundleListener((BundleListener)this.m_log);
        context.addFrameworkListener((FrameworkListener)this.m_log);
        context.addServiceListener((ServiceListener)this.m_log);
        context.registerService(LogService.class.getName(), (Object)new LogServiceFactory(this.m_log), null);
        context.registerService(LogReaderService.class.getName(), (Object)new LogReaderServiceFactory(this.m_log), null);
    }

    public void stop(BundleContext context) throws Exception {
        this.m_log.close();
    }
}

