/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.system.AggregateProcessInfo;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.database.ConnectionPoolingSupport;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.database.PooledConnectionProvider;
import org.rhq.plugins.mysql.MySqlDiscoveryComponent;
import org.rhq.plugins.mysql.MySqlPooledConnectionProvider;

public class MySqlComponent
implements DatabaseComponent<ResourceComponent<?>>,
ConnectionPoolingSupport,
ResourceComponent<ResourceComponent<?>>,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(MySqlComponent.class);
    private ResourceContext resourceContext;
    private AggregateProcessInfo aggregateProcessInfo;
    private Map<String, String> globalStatusValues = new HashMap<String, String>();
    private Map<String, String> globalVariables = new HashMap<String, String>();
    private MySqlPooledConnectionProvider pooledConnectionProvider;
    @Deprecated
    private Connection sharedConnection;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        this.buildSharedConnectionIfNeeded();
        this.pooledConnectionProvider = new MySqlPooledConnectionProvider(resourceContext.getPluginConfiguration());
        ProcessInfo processInfo = resourceContext.getNativeProcess();
        if (processInfo != null) {
            this.aggregateProcessInfo = processInfo.getAggregateProcessTree();
        } else {
            this.findProcessInfo();
        }
    }

    private void buildSharedConnectionIfNeeded() {
        block3: {
            try {
                if (this.sharedConnection == null || this.sharedConnection.isClosed()) {
                    this.sharedConnection = MySqlDiscoveryComponent.buildConnection(this.resourceContext.getPluginConfiguration());
                }
            }
            catch (SQLException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"Could not build shared connection", (Throwable)e);
            }
        }
    }

    public void stop() {
        this.resourceContext = null;
        DatabasePluginUtil.safeClose((Connection)this.sharedConnection);
        this.sharedConnection = null;
        this.pooledConnectionProvider.close();
        this.pooledConnectionProvider = null;
        this.aggregateProcessInfo = null;
    }

    public boolean supportsConnectionPooling() {
        return true;
    }

    public PooledConnectionProvider getPooledConnectionProvider() {
        return this.pooledConnectionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        Connection jdbcConnection = null;
        try {
            jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
            AvailabilityType availabilityType = jdbcConnection.isValid(1) ? AvailabilityType.UP : AvailabilityType.DOWN;
            return availabilityType;
        }
        catch (SQLException e) {
            AvailabilityType availabilityType = AvailabilityType.DOWN;
            return availabilityType;
        }
        finally {
            DatabasePluginUtil.safeClose((Connection)jdbcConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Connection jdbcConnection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            jdbcConnection = this.getPooledConnectionProvider().getPooledConnection();
            statement = jdbcConnection.createStatement();
            resultSet = statement.executeQuery("SHOW GLOBAL STATUS");
            while (resultSet.next()) {
                this.globalStatusValues.put(resultSet.getString(1), resultSet.getString(2));
            }
            resultSet.close();
            resultSet = statement.executeQuery("select * from information_schema.global_variables");
            while (resultSet.next()) {
                this.globalVariables.put(resultSet.getString(1), resultSet.getString(2));
            }
        }
        catch (SQLException ignore) {
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, resultSet);
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                throw throwable;
            }
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
        this.aggregateProcessInfo = this.findProcessInfo();
        for (MeasurementScheduleRequest request : metrics) {
            String requestName = request.getName();
            if (requestName.startsWith("Process") && this.aggregateProcessInfo != null) {
                this.aggregateProcessInfo.refresh();
                if ("Process.aggregateMemory.resident".equals(requestName)) {
                    long mem = this.aggregateProcessInfo.getAggregateMemory().getResident();
                    report.addData(new MeasurementDataNumeric(request, new Double(mem)));
                    continue;
                }
                if ("Process.aggregateMemory.size".equals(requestName)) {
                    long value = this.aggregateProcessInfo.getAggregateMemory().getSize();
                    report.addData(new MeasurementDataNumeric(request, new Double(value)));
                    continue;
                }
                if ("Process.aggregateMemory.pageFaults".equals(requestName)) {
                    long value = this.aggregateProcessInfo.getAggregateMemory().getPageFaults();
                    report.addData(new MeasurementDataNumeric(request, new Double(value)));
                    continue;
                }
                if ("Process.aggregateCpu.user".equals(requestName)) {
                    long value = this.aggregateProcessInfo.getAggregateCpu().getUser();
                    report.addData(new MeasurementDataNumeric(request, new Double(value)));
                    continue;
                }
                if ("Process.aggregateCpu.sys".equals(requestName)) {
                    long value = this.aggregateProcessInfo.getAggregateCpu().getSys();
                    report.addData(new MeasurementDataNumeric(request, new Double(value)));
                    continue;
                }
                if ("Process.aggregateCpu.percent".equals(requestName)) {
                    double value = this.aggregateProcessInfo.getAggregateCpu().getPercent();
                    report.addData(new MeasurementDataNumeric(request, new Double(value)));
                    continue;
                }
                if ("Process.aggregateCpu.total".equals(requestName)) {
                    long value = this.aggregateProcessInfo.getAggregateCpu().getTotal();
                    report.addData(new MeasurementDataNumeric(request, new Double(value)));
                    continue;
                }
                if (!"Process.aggregateFileDescriptor.total".equals(requestName)) continue;
                long value = this.aggregateProcessInfo.getAggregateFileDescriptor().getTotal();
                report.addData(new MeasurementDataNumeric(request, new Double(value)));
                continue;
            }
            if (request.getDataType() != DataType.MEASUREMENT) continue;
            try {
                String strVal = this.globalStatusValues.get(request.getName());
                double val = Double.parseDouble(strVal);
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(val)));
            }
            catch (Exception ignore) {}
        }
    }

    public Connection getConnection() {
        this.buildSharedConnectionIfNeeded();
        return this.sharedConnection;
    }

    public void removeConnection() {
        DatabasePluginUtil.safeClose((Connection)this.sharedConnection);
        this.sharedConnection = null;
    }

    private AggregateProcessInfo findProcessInfo() {
        AggregateProcessInfo result = null;
        if (this.aggregateProcessInfo != null && this.aggregateProcessInfo.freshSnapshot().isRunning()) {
            result = this.aggregateProcessInfo;
        } else {
            long pid = this.findPID();
            if (pid != -1L) {
                List processes = this.resourceContext.getSystemInformation().getAllProcesses();
                for (ProcessInfo pi : processes) {
                    if (pid != pi.getPid()) continue;
                    result = pi.getAggregateProcessTree();
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findPID() {
        long result = -1L;
        String pidFile = this.globalVariables.get("PID_FILE");
        if (pidFile == null) {
            return result;
        }
        File file = new File(pidFile);
        if (file.canRead()) {
            try {
                FileReader pidFileReader = new FileReader(file);
                try {
                    char[] pidData = new char[(int)file.length()];
                    pidFileReader.read(pidData);
                    String pidString = new String(pidData);
                    pidString = pidString.trim();
                    result = Long.valueOf(pidString);
                }
                finally {
                    pidFileReader.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)("Unable to read MySQL pid file " + pidFile));
            }
        }
        return result;
    }
}

