/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import org.jboss.as.pojo.PojoMessages;
import org.jboss.as.pojo.descriptor.ConfigVisitor;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.pojo.service.Configurator;

public class StringValueConfig
extends ValueConfig {
    private static final long serialVersionUID = 1L;
    private String value;
    private boolean replaceProperties;
    private boolean trim;
    private Class<?> clazz;

    @Override
    public void visit(ConfigVisitor visitor) {
        if (this.getType() != null) {
            try {
                this.clazz = visitor.getModule().getClassLoader().loadClass(this.getType());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    @Override
    protected Object getClassValue(Class<?> type) {
        if (type == null) {
            type = this.clazz;
        }
        if (type == null) {
            throw PojoMessages.MESSAGES.cannotDetermineInjectedType(this.toString());
        }
        try {
            return Configurator.convertValue(type, this.value, this.replaceProperties, this.trim);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setReplaceProperties(boolean replaceProperties) {
        this.replaceProperties = replaceProperties;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }
}

