/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.modcluster.CustomLoadMetricDefinition;
import org.jboss.as.modcluster.Element;
import org.jboss.as.modcluster.LoadMetricDefinition;
import org.jboss.as.modcluster.ModClusterConfigResourceDefinition;
import org.jboss.as.modcluster.ModClusterExtension;
import org.jboss.as.modcluster.ModClusterSSLResourceDefinition;
import org.jboss.as.modcluster.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class ModClusterSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode node = context.getModelNode();
        if (node.get(ModClusterExtension.CONFIGURATION_PATH.getKeyValuePair()).isDefined()) {
            ModClusterSubsystemXMLWriter.writeModClusterConfig(writer, node.get(ModClusterExtension.CONFIGURATION_PATH.getKeyValuePair()));
        } else {
            ModClusterSubsystemXMLWriter.writeModClusterConfig(writer, node);
        }
        writer.writeEndElement();
    }

    static void writeModClusterConfig(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.MOD_CLUSTER_CONFIG.getLocalName());
        ModClusterSubsystemXMLWriter.writePropConf(writer, config);
        if (config.hasDefined("simple-load-provider")) {
            ModClusterSubsystemXMLWriter.writeSimpleLoadProvider(writer, config);
        }
        if (config.get(ModClusterExtension.DYNAMIC_LOAD_PROVIDER_PATH.getKeyValuePair()).isDefined()) {
            ModClusterSubsystemXMLWriter.writeDynamicLoadProvider(writer, config.get(ModClusterExtension.DYNAMIC_LOAD_PROVIDER_PATH.getKeyValuePair()));
        }
        if (config.get(ModClusterExtension.SSL_CONFIGURATION_PATH.getKeyValuePair()).isDefined()) {
            ModClusterSubsystemXMLWriter.writeSSL(writer, config.get(ModClusterExtension.SSL_CONFIGURATION_PATH.getKeyValuePair()));
        }
        writer.writeEndElement();
    }

    static void writePropConf(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        for (SimpleAttributeDefinition def : ModClusterConfigResourceDefinition.ATTRIBUTES) {
            def.marshallAsAttribute(config, true, (XMLStreamWriter)writer);
        }
    }

    static void writeSSL(XMLExtendedStreamWriter writer, ModelNode sslConfig) throws XMLStreamException {
        writer.writeStartElement(Element.SSL.getLocalName());
        for (SimpleAttributeDefinition def : ModClusterSSLResourceDefinition.ATTRIBUTES) {
            def.marshallAsAttribute(sslConfig, false, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    static void writeSimpleLoadProvider(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.SIMPLE_LOAD_PROVIDER.getLocalName());
        ModClusterConfigResourceDefinition.SIMPLE_LOAD_PROVIDER.marshallAsAttribute(config, false, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    static void writeDynamicLoadProvider(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.DYNAMIC_LOAD_PROVIDER.getLocalName());
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "history", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "decay", config);
        if (config.hasDefined("load-metric")) {
            ModClusterSubsystemXMLWriter.writeLoadMetric(writer, config.get("load-metric"));
        }
        if (config.hasDefined("custom-load-metric")) {
            ModClusterSubsystemXMLWriter.writeCustomLoadMetric(writer, config.get("custom-load-metric"));
        }
        writer.writeEndElement();
    }

    static void writeLoadMetric(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        for (Property prop : config.asPropertyList()) {
            ModelNode node = prop.getValue();
            writer.writeStartElement(Element.LOAD_METRIC.getLocalName());
            LoadMetricDefinition.TYPE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            LoadMetricDefinition.WEIGHT.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            LoadMetricDefinition.CAPACITY.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            if (node.get("property").isDefined()) {
                for (Property property : node.get("property").asPropertyList()) {
                    ModClusterSubsystemXMLWriter.writeProperty(writer, property);
                }
            }
            writer.writeEndElement();
        }
    }

    static void writeCustomLoadMetric(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        for (Property prop : config.asPropertyList()) {
            ModelNode node = prop.getValue();
            writer.writeStartElement(Element.CUSTOM_LOAD_METRIC.getLocalName());
            CustomLoadMetricDefinition.CLASS.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            LoadMetricDefinition.WEIGHT.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            LoadMetricDefinition.CAPACITY.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            if (node.get("property").isDefined()) {
                for (Property property : node.get("property").asPropertyList()) {
                    ModClusterSubsystemXMLWriter.writeProperty(writer, property);
                }
            }
            writer.writeEndElement();
        }
    }

    static void writeAttribute(XMLExtendedStreamWriter writer, String name, ModelNode node) throws XMLStreamException {
        if (node.hasDefined(name)) {
            writer.writeAttribute(name, node.get(name).asString());
        }
    }

    static void writeProperty(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeStartElement(Element.PROPERTY.getLocalName());
        writer.writeAttribute("name", property.getName());
        writer.writeAttribute("value", property.getValue().asString());
        writer.writeEndElement();
    }
}

