/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.modcluster.ModCluster;
import org.jboss.as.modcluster.ModClusterDefinition;
import org.jboss.as.modcluster.ModClusterExtension;
import org.jboss.as.modcluster.ModClusterLogger;
import org.jboss.as.modcluster.ModClusterService;
import org.jboss.as.modcluster.Proxy;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class ModClusterRemoveProxy
implements OperationStepHandler {
    static final ModClusterRemoveProxy INSTANCE = new ModClusterRemoveProxy();

    static OperationDefinition getDefinition(ResourceDescriptionResolver descriptionResolver) {
        return new SimpleOperationDefinitionBuilder("remove-proxy", descriptionResolver).addParameter((AttributeDefinition)ModClusterDefinition.HOST).addParameter((AttributeDefinition)ModClusterDefinition.PORT).setRuntimeOnly().addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF).build();
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer() && context.getServiceRegistry(false).getService(ModClusterService.NAME) != null) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry(false).getService(ModClusterService.NAME);
                    final ModCluster modcluster = (ModCluster)controller.getValue();
                    ModClusterLogger.ROOT_LOGGER.debugf("remove-proxy: %s", operation);
                    final Proxy proxy = new Proxy(operation);
                    modcluster.removeProxy(proxy.host, proxy.port);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            modcluster.addProxy(proxy.host, proxy.port);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }
}

