/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.ejb.client.remoting.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.DuplicateRegistrationException;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.ServiceRegistrationException;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

class EndpointPool {
    private static final Logger logger = Logger.getLogger(EndpointPool.class);
    static final EndpointPool INSTANCE = new EndpointPool();
    private final ConcurrentMap<CacheKey, PooledEndpoint> cache = new ConcurrentHashMap<CacheKey, PooledEndpoint>();

    private EndpointPool() {
    }

    synchronized Endpoint getEndpoint(String endpointName, OptionMap endPointCreationOptions, OptionMap remoteConnectionProviderOptions) throws IOException {
        CacheKey key = new CacheKey(remoteConnectionProviderOptions, endPointCreationOptions, endpointName);
        PooledEndpoint pooledEndpoint = (PooledEndpoint)this.cache.get(key);
        if (pooledEndpoint == null) {
            Endpoint endpoint = Remoting.createEndpoint((String)endpointName, (OptionMap)endPointCreationOptions);
            endpoint.addConnectionProvider("remote", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), remoteConnectionProviderOptions);
            endpoint.addCloseHandler((CloseHandler)new CacheEntryRemovalHandler(key));
            pooledEndpoint = new PooledEndpoint(key, endpoint);
            this.cache.putIfAbsent(key, pooledEndpoint);
        }
        pooledEndpoint.referenceCount.incrementAndGet();
        return pooledEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void release(CacheKey endpointHash, boolean async) {
        PooledEndpoint pooledEndpoint = (PooledEndpoint)this.cache.get(endpointHash);
        if (pooledEndpoint.referenceCount.decrementAndGet() == 0) {
            try {
                if (async) {
                    pooledEndpoint.underlyingEndpoint.closeAsync();
                } else {
                    EndpointPool.safeClose((Closeable)pooledEndpoint.underlyingEndpoint);
                }
            }
            finally {
                this.cache.remove(endpointHash);
            }
        }
    }

    private synchronized void shutdown() {
        for (Map.Entry entry : this.cache.entrySet()) {
            EndpointPool.safeClose((Closeable)((PooledEndpoint)entry.getValue()).underlyingEndpoint);
        }
        this.cache.clear();
    }

    private static void safeClose(Closeable closable) {
        try {
            closable.close();
        }
        catch (Throwable t) {
            logger.debug((Object)"Failed to close endpoint ", t);
        }
    }

    static {
        SecurityActions.addShutdownHook(new Thread(new ShutdownTask(INSTANCE)));
    }

    private class CacheEntryRemovalHandler
    implements CloseHandler<HandleableCloseable> {
        private final CacheKey key;

        CacheEntryRemovalHandler(CacheKey key) {
            this.key = key;
        }

        public void handleClose(HandleableCloseable closable, IOException e) {
            EndpointPool.this.cache.remove(this.key);
        }
    }

    private static final class ShutdownTask
    implements Runnable {
        private final EndpointPool pool;

        ShutdownTask(EndpointPool pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            this.pool.shutdown();
        }
    }

    private static class CacheKey {
        final String endpointName;
        final OptionMap connectOptions;
        final OptionMap remoteConnectionProviderOptions;

        private CacheKey(OptionMap remoteConnectionProviderOptions, OptionMap connectOptions, String endpointName) {
            this.remoteConnectionProviderOptions = remoteConnectionProviderOptions;
            this.connectOptions = connectOptions;
            this.endpointName = endpointName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.connectOptions != null ? !this.connectOptions.equals(cacheKey.connectOptions) : cacheKey.connectOptions != null) {
                return false;
            }
            if (this.endpointName != null ? !this.endpointName.equals(cacheKey.endpointName) : cacheKey.endpointName != null) {
                return false;
            }
            return !(this.remoteConnectionProviderOptions != null ? !this.remoteConnectionProviderOptions.equals(cacheKey.remoteConnectionProviderOptions) : cacheKey.remoteConnectionProviderOptions != null);
        }

        public int hashCode() {
            int result = this.endpointName != null ? this.endpointName.hashCode() : 0;
            result = 31 * result + (this.connectOptions != null ? this.connectOptions.hashCode() : 0);
            result = 31 * result + (this.remoteConnectionProviderOptions != null ? this.remoteConnectionProviderOptions.hashCode() : 0);
            return result;
        }
    }

    private class PooledEndpoint
    implements Endpoint {
        private final AtomicInteger referenceCount = new AtomicInteger(0);
        private final CacheKey endpointHash;
        private final Endpoint underlyingEndpoint;

        private PooledEndpoint(CacheKey endpointHash, Endpoint endpoint) {
            this.endpointHash = endpointHash;
            this.underlyingEndpoint = endpoint;
        }

        public String getName() {
            return this.underlyingEndpoint.getName();
        }

        public Registration registerService(String s, OpenListener openListener, OptionMap optionMap) throws ServiceRegistrationException {
            return this.underlyingEndpoint.registerService(s, openListener, optionMap);
        }

        public IoFuture<Connection> connect(URI uri) throws IOException {
            return this.underlyingEndpoint.connect(uri);
        }

        public IoFuture<Connection> connect(URI uri, OptionMap optionMap) throws IOException {
            return this.underlyingEndpoint.connect(uri, optionMap);
        }

        public IoFuture<Connection> connect(URI uri, OptionMap optionMap, CallbackHandler callbackHandler) throws IOException {
            return this.underlyingEndpoint.connect(uri, optionMap, callbackHandler);
        }

        public IoFuture<Connection> connect(URI uri, OptionMap optionMap, CallbackHandler callbackHandler, SSLContext sslContext) throws IOException {
            return this.underlyingEndpoint.connect(uri, optionMap, callbackHandler, sslContext);
        }

        public IoFuture<Connection> connect(URI uri, OptionMap optionMap, CallbackHandler callbackHandler, XnioSsl xnioSsl) throws IOException {
            return this.underlyingEndpoint.connect(uri, optionMap, callbackHandler, xnioSsl);
        }

        public IoFuture<Connection> connect(URI uri, OptionMap optionMap, String s, String s1, char[] chars) throws IOException {
            return this.underlyingEndpoint.connect(uri, optionMap, s, s1, chars);
        }

        public IoFuture<Connection> connect(URI uri, OptionMap optionMap, String s, String s1, char[] chars, SSLContext sslContext) throws IOException {
            return this.underlyingEndpoint.connect(uri, optionMap, s, s1, chars, sslContext);
        }

        public IoFuture<Connection> connect(URI uri, OptionMap optionMap, String s, String s1, char[] chars, XnioSsl xnioSsl) throws IOException {
            return this.underlyingEndpoint.connect(uri, optionMap, s, s1, chars, xnioSsl);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1) throws IOException {
            return this.underlyingEndpoint.connect(s, socketAddress, socketAddress1);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1, OptionMap optionMap) throws IOException {
            return this.underlyingEndpoint.connect(s, socketAddress, socketAddress1, optionMap);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1, OptionMap optionMap, CallbackHandler callbackHandler) throws IOException {
            return this.underlyingEndpoint.connect(s, socketAddress, socketAddress1, optionMap, callbackHandler);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1, OptionMap optionMap, CallbackHandler callbackHandler, SSLContext sslContext) throws IOException {
            return this.underlyingEndpoint.connect(s, socketAddress, socketAddress1, optionMap, callbackHandler, sslContext);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1, OptionMap optionMap, CallbackHandler callbackHandler, XnioSsl xnioSsl) throws IOException {
            return this.underlyingEndpoint.connect(s, socketAddress, socketAddress1, optionMap, callbackHandler, xnioSsl);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1, OptionMap optionMap, String s1, String s2, char[] chars) throws IOException {
            return this.underlyingEndpoint.connect(s, socketAddress, socketAddress1, optionMap, s1, s2, chars);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1, OptionMap optionMap, String s1, String s2, char[] chars, SSLContext sslContext) throws IOException {
            return this.underlyingEndpoint.connect(s, socketAddress, socketAddress1, optionMap, s1, s2, chars, sslContext);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1, OptionMap optionMap, String s1, String s2, char[] chars, XnioSsl xnioSsl) throws IOException {
            return this.underlyingEndpoint.connect(s, socketAddress, socketAddress1, optionMap, s1, s2, chars, xnioSsl);
        }

        public Registration addConnectionProvider(String s, ConnectionProviderFactory connectionProviderFactory, OptionMap optionMap) throws DuplicateRegistrationException, IOException {
            return this.underlyingEndpoint.addConnectionProvider(s, connectionProviderFactory, optionMap);
        }

        public <T> T getConnectionProviderInterface(String s, Class<T> tClass) throws UnknownURISchemeException, ClassCastException {
            return (T)this.underlyingEndpoint.getConnectionProviderInterface(s, tClass);
        }

        public boolean isValidUriScheme(String s) {
            return this.underlyingEndpoint.isValidUriScheme(s);
        }

        public XnioWorker getXnioWorker() {
            return this.underlyingEndpoint.getXnioWorker();
        }

        public void close() throws IOException {
            EndpointPool.this.release(this.endpointHash, false);
        }

        public void awaitClosed() throws InterruptedException {
            this.underlyingEndpoint.awaitClosed();
        }

        public void awaitClosedUninterruptibly() {
            this.underlyingEndpoint.awaitClosedUninterruptibly();
        }

        public void closeAsync() {
            EndpointPool.this.release(this.endpointHash, true);
        }

        public HandleableCloseable.Key addCloseHandler(CloseHandler<? super Endpoint> closeHandler) {
            return this.underlyingEndpoint.addCloseHandler(closeHandler);
        }

        public Attachments getAttachments() {
            return this.underlyingEndpoint.getAttachments();
        }
    }
}

