/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.attr.AnyURIAttribute;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.StringAttribute;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.cond.Expression;
import org.jboss.security.xacml.sunxacml.cond.FunctionBase;
import org.jboss.security.xacml.sunxacml.ctx.Status;

public class URLStringCatFunction
extends FunctionBase {
    public static final String NAME_URL_STRING_CONCATENATE = "urn:oasis:names:tc:xacml:2.0:function:url-string-concatenate";

    public URLStringCatFunction() {
        super(NAME_URL_STRING_CONCATENATE, 0, "http://www.w3.org/2001/XMLSchema#anyURI", false);
    }

    @Override
    public void checkInputs(List inputs) throws IllegalArgumentException {
        Iterator it = inputs.iterator();
        while (it.hasNext()) {
            if (!((Expression)it.next()).returnsBag()) continue;
            throw new IllegalArgumentException("urn:oasis:names:tc:xacml:2.0:function:url-string-concatenate doesn't accept bags");
        }
        this.checkInputsNoBag(inputs);
    }

    @Override
    public void checkInputsNoBag(List inputs) throws IllegalArgumentException {
        if (inputs.size() < 2) {
            throw new IllegalArgumentException("not enough args to urn:oasis:names:tc:xacml:2.0:function:url-string-concatenate");
        }
        Iterator it = inputs.iterator();
        if (!((Expression)it.next()).getType().toString().equals("http://www.w3.org/2001/XMLSchema#anyURI")) {
            throw new IllegalArgumentException("illegal parameter");
        }
        while (it.hasNext()) {
            if (((Expression)it.next()).getType().toString().equals("http://www.w3.org/2001/XMLSchema#string")) continue;
            throw new IllegalArgumentException("illegal parameter");
        }
    }

    @Override
    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        String str = ((AnyURIAttribute)argValues[0]).getValue().toString();
        for (int i = 1; i < argValues.length; ++i) {
            str = str + ((StringAttribute)argValues[i]).getValue();
        }
        try {
            return new EvaluationResult(new AnyURIAttribute(new URI(str)));
        }
        catch (URISyntaxException use) {
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
            String message = "urn:oasis:names:tc:xacml:2.0:function:url-string-concatenate didn't produce a valid URI: " + str;
            return new EvaluationResult(new Status(code, message));
        }
    }
}

