/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.locators;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.bridge.PolicySetFinderModule;
import org.jboss.security.xacml.bridge.WrapperPolicyFinderModule;
import org.jboss.security.xacml.interfaces.XACMLPolicy;
import org.jboss.security.xacml.locators.AbstractJBossPolicyLocator;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.Policy;
import org.jboss.security.xacml.sunxacml.PolicySet;

public class JBossPolicySetLocator
extends AbstractJBossPolicyLocator {
    public JBossPolicySetLocator() {
    }

    public JBossPolicySetLocator(Set<XACMLPolicy> policies) {
        this.setPolicies(policies);
    }

    @Override
    public void setPolicies(Set<XACMLPolicy> policies) {
        this.policies = policies;
        for (XACMLPolicy xp : policies) {
            if (xp.getType() == 0) {
                PolicySetFinderModule psfm = this.getPopulatedPolicySetFinderModule(xp);
                if (psfm == null) continue;
                this.pfml.add(psfm);
                continue;
            }
            if (xp.getType() != 1) continue;
            Policy p = (Policy)xp.get("underlying_policy");
            WrapperPolicyFinderModule wpfm = new WrapperPolicyFinderModule(p);
            this.pfml.add(wpfm);
        }
        this.map.put("policy_finder_module", this.pfml);
    }

    protected PolicySetFinderModule getPopulatedPolicySetFinderModule(XACMLPolicy xpolicy) {
        PolicySetFinderModule psfm = new PolicySetFinderModule();
        ArrayList<AbstractPolicy> sunxacmlPolicies = new ArrayList<AbstractPolicy>();
        this.recursivePopulate(xpolicy, sunxacmlPolicies, psfm);
        psfm.set((PolicySet)xpolicy.get("underlying_policy"), sunxacmlPolicies);
        xpolicy.set("policy_finder_module", psfm);
        return psfm;
    }

    protected void recursivePopulate(XACMLPolicy policy, List<AbstractPolicy> policies, PolicySetFinderModule psfm) {
        List<XACMLPolicy> policyList = policy.getEnclosingPolicies();
        for (XACMLPolicy xp : policyList) {
            AbstractPolicy p = (AbstractPolicy)xp.get("underlying_policy");
            policies.add(p);
            if (!(p instanceof PolicySet)) continue;
            this.recursivePopulate(xp, policies, psfm);
        }
    }
}

