/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen;

import java.util.Iterator;
import java.util.LinkedList;
import org.jaxen.JaxenException;
import org.jaxen.expr.DefaultXPathFactory;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.Predicated;
import org.jaxen.expr.Step;
import org.jaxen.expr.XPathExpr;
import org.jaxen.expr.XPathFactory;
import org.jaxen.saxpath.XPathHandler;

public class JaxenHandler
implements XPathHandler {
    private XPathFactory xpathFactory;
    private XPathExpr xpath;
    protected boolean simplified;
    protected LinkedList stack = new LinkedList();

    public JaxenHandler() {
        this.xpathFactory = new DefaultXPathFactory();
    }

    public void setXPathFactory(XPathFactory xpathFactory) {
        this.xpathFactory = xpathFactory;
    }

    public XPathFactory getXPathFactory() {
        return this.xpathFactory;
    }

    public XPathExpr getXPathExpr() {
        return this.getXPathExpr(true);
    }

    public XPathExpr getXPathExpr(boolean shouldSimplify) {
        if (shouldSimplify && !this.simplified) {
            this.xpath.simplify();
            this.simplified = true;
        }
        return this.xpath;
    }

    @Override
    public void startXPath() {
        this.simplified = false;
        this.pushFrame();
    }

    @Override
    public void endXPath() throws JaxenException {
        this.xpath = this.getXPathFactory().createXPath((Expr)this.pop());
        this.popFrame();
    }

    @Override
    public void startPathExpr() {
        this.pushFrame();
    }

    @Override
    public void endPathExpr() throws JaxenException {
        FilterExpr filterExpr;
        LocationPath locationPath;
        if (this.stackSize() == 2) {
            locationPath = (LocationPath)this.pop();
            filterExpr = (FilterExpr)this.pop();
        } else {
            Object popped = this.pop();
            if (popped instanceof LocationPath) {
                locationPath = (LocationPath)popped;
                filterExpr = null;
            } else {
                locationPath = null;
                filterExpr = (FilterExpr)popped;
            }
        }
        this.popFrame();
        this.push(this.getXPathFactory().createPathExpr(filterExpr, locationPath));
    }

    @Override
    public void startAbsoluteLocationPath() throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createAbsoluteLocationPath());
    }

    @Override
    public void endAbsoluteLocationPath() throws JaxenException {
        this.endLocationPath();
    }

    @Override
    public void startRelativeLocationPath() throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createRelativeLocationPath());
    }

    @Override
    public void endRelativeLocationPath() throws JaxenException {
        this.endLocationPath();
    }

    protected void endLocationPath() throws JaxenException {
        LocationPath path = (LocationPath)this.peekFrame().removeFirst();
        this.addSteps(path, this.popFrame().iterator());
        this.push(path);
    }

    protected void addSteps(LocationPath locationPath, Iterator stepIter) {
        while (stepIter.hasNext()) {
            locationPath.addStep((Step)stepIter.next());
        }
    }

    @Override
    public void startNameStep(int axis, String prefix, String localName) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createNameStep(axis, prefix, localName));
    }

    @Override
    public void endNameStep() {
        this.endStep();
    }

    @Override
    public void startTextNodeStep(int axis) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createTextNodeStep(axis));
    }

    @Override
    public void endTextNodeStep() {
        this.endStep();
    }

    @Override
    public void startCommentNodeStep(int axis) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createCommentNodeStep(axis));
    }

    @Override
    public void endCommentNodeStep() {
        this.endStep();
    }

    @Override
    public void startAllNodeStep(int axis) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createAllNodeStep(axis));
    }

    @Override
    public void endAllNodeStep() {
        this.endStep();
    }

    @Override
    public void startProcessingInstructionNodeStep(int axis, String name) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createProcessingInstructionNodeStep(axis, name));
    }

    @Override
    public void endProcessingInstructionNodeStep() {
        this.endStep();
    }

    protected void endStep() {
        Step step = (Step)this.peekFrame().removeFirst();
        this.addPredicates(step, this.popFrame().iterator());
        this.push(step);
    }

    @Override
    public void startPredicate() {
        this.pushFrame();
    }

    @Override
    public void endPredicate() throws JaxenException {
        Predicate predicate = this.getXPathFactory().createPredicate((Expr)this.pop());
        this.popFrame();
        this.push(predicate);
    }

    @Override
    public void startFilterExpr() {
        this.pushFrame();
    }

    @Override
    public void endFilterExpr() throws JaxenException {
        Expr expr = (Expr)this.peekFrame().removeFirst();
        FilterExpr filter = this.getXPathFactory().createFilterExpr(expr);
        Iterator predIter = this.popFrame().iterator();
        this.addPredicates(filter, predIter);
        this.push(filter);
    }

    protected void addPredicates(Predicated obj, Iterator predIter) {
        while (predIter.hasNext()) {
            obj.addPredicate((Predicate)predIter.next());
        }
    }

    protected void returnExpr() {
        Expr expr = (Expr)this.pop();
        this.popFrame();
        this.push(expr);
    }

    @Override
    public void startOrExpr() {
    }

    @Override
    public void endOrExpr(boolean create) throws JaxenException {
        if (create) {
            Expr rhs = (Expr)this.pop();
            Expr lhs = (Expr)this.pop();
            this.push(this.getXPathFactory().createOrExpr(lhs, rhs));
        }
    }

    @Override
    public void startAndExpr() {
    }

    @Override
    public void endAndExpr(boolean create) throws JaxenException {
        if (create) {
            Expr rhs = (Expr)this.pop();
            Expr lhs = (Expr)this.pop();
            this.push(this.getXPathFactory().createAndExpr(lhs, rhs));
        }
    }

    @Override
    public void startEqualityExpr() {
    }

    @Override
    public void endEqualityExpr(int operator) throws JaxenException {
        if (operator != 0) {
            Expr rhs = (Expr)this.pop();
            Expr lhs = (Expr)this.pop();
            this.push(this.getXPathFactory().createEqualityExpr(lhs, rhs, operator));
        }
    }

    @Override
    public void startRelationalExpr() {
    }

    @Override
    public void endRelationalExpr(int operator) throws JaxenException {
        if (operator != 0) {
            Expr rhs = (Expr)this.pop();
            Expr lhs = (Expr)this.pop();
            this.push(this.getXPathFactory().createRelationalExpr(lhs, rhs, operator));
        }
    }

    @Override
    public void startAdditiveExpr() {
    }

    @Override
    public void endAdditiveExpr(int operator) throws JaxenException {
        if (operator != 0) {
            Expr rhs = (Expr)this.pop();
            Expr lhs = (Expr)this.pop();
            this.push(this.getXPathFactory().createAdditiveExpr(lhs, rhs, operator));
        }
    }

    @Override
    public void startMultiplicativeExpr() {
    }

    @Override
    public void endMultiplicativeExpr(int operator) throws JaxenException {
        if (operator != 0) {
            Expr rhs = (Expr)this.pop();
            Expr lhs = (Expr)this.pop();
            this.push(this.getXPathFactory().createMultiplicativeExpr(lhs, rhs, operator));
        }
    }

    @Override
    public void startUnaryExpr() {
    }

    @Override
    public void endUnaryExpr(int operator) throws JaxenException {
        if (operator != 0) {
            this.push(this.getXPathFactory().createUnaryExpr((Expr)this.pop(), operator));
        }
    }

    @Override
    public void startUnionExpr() {
    }

    @Override
    public void endUnionExpr(boolean create) throws JaxenException {
        if (create) {
            Expr rhs = (Expr)this.pop();
            Expr lhs = (Expr)this.pop();
            this.push(this.getXPathFactory().createUnionExpr(lhs, rhs));
        }
    }

    @Override
    public void number(int number) throws JaxenException {
        this.push(this.getXPathFactory().createNumberExpr(number));
    }

    @Override
    public void number(double number) throws JaxenException {
        this.push(this.getXPathFactory().createNumberExpr(number));
    }

    @Override
    public void literal(String literal) throws JaxenException {
        this.push(this.getXPathFactory().createLiteralExpr(literal));
    }

    @Override
    public void variableReference(String prefix, String variableName) throws JaxenException {
        this.push(this.getXPathFactory().createVariableReferenceExpr(prefix, variableName));
    }

    @Override
    public void startFunction(String prefix, String functionName) throws JaxenException {
        this.pushFrame();
        this.push(this.getXPathFactory().createFunctionCallExpr(prefix, functionName));
    }

    @Override
    public void endFunction() {
        FunctionCallExpr function = (FunctionCallExpr)this.peekFrame().removeFirst();
        this.addParameters(function, this.popFrame().iterator());
        this.push(function);
    }

    protected void addParameters(FunctionCallExpr function, Iterator paramIter) {
        while (paramIter.hasNext()) {
            function.addParameter((Expr)paramIter.next());
        }
    }

    protected int stackSize() {
        return this.peekFrame().size();
    }

    protected void push(Object obj) {
        this.peekFrame().addLast(obj);
    }

    protected Object pop() {
        return this.peekFrame().removeLast();
    }

    protected boolean canPop() {
        return this.peekFrame().size() > 0;
    }

    protected void pushFrame() {
        this.stack.addLast(new LinkedList());
    }

    protected LinkedList popFrame() {
        return (LinkedList)this.stack.removeLast();
    }

    protected LinkedList peekFrame() {
        return (LinkedList)this.stack.getLast();
    }
}

