/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.UnsupportedDurationField;

final class BasicSingleEraDateTimeField
extends BaseDateTimeField {
    private static final int ERA_VALUE = 1;
    private final String iEraText;

    BasicSingleEraDateTimeField(String string) {
        super(DateTimeFieldType.era());
        this.iEraText = string;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public int get(long l) {
        return 1;
    }

    @Override
    public long set(long l, int n) {
        FieldUtils.verifyValueBounds(this, n, 1, 1);
        return l;
    }

    @Override
    public long set(long l, String string, Locale locale) {
        if (!this.iEraText.equals(string) && !"1".equals(string)) {
            throw new IllegalFieldValueException(DateTimeFieldType.era(), string);
        }
        return l;
    }

    @Override
    public long roundFloor(long l) {
        return Long.MIN_VALUE;
    }

    @Override
    public long roundCeiling(long l) {
        return Long.MAX_VALUE;
    }

    @Override
    public long roundHalfFloor(long l) {
        return Long.MIN_VALUE;
    }

    @Override
    public long roundHalfCeiling(long l) {
        return Long.MIN_VALUE;
    }

    @Override
    public long roundHalfEven(long l) {
        return Long.MIN_VALUE;
    }

    @Override
    public DurationField getDurationField() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    @Override
    public DurationField getRangeDurationField() {
        return null;
    }

    @Override
    public int getMinimumValue() {
        return 1;
    }

    @Override
    public int getMaximumValue() {
        return 1;
    }

    @Override
    public String getAsText(int n, Locale locale) {
        return this.iEraText;
    }

    @Override
    public int getMaximumTextLength(Locale locale) {
        return this.iEraText.length();
    }
}

