/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.obfuscation;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.rhq.core.util.obfuscation.PicketBoxObfuscator;

public class ObfuscatedPreferences
extends Preferences {
    private Preferences actualPreferences;
    private Set<String> restrictedPreferences = new HashSet<String>();
    private Set<String> userRestrictedPreferences = new HashSet<String>();

    public ObfuscatedPreferences(Preferences actualPreferences, Class classz) {
        this.actualPreferences = actualPreferences;
        for (Field field : classz.getFields()) {
            Restricted restricted = field.getAnnotation(Restricted.class);
            if (restricted == null) continue;
            try {
                String restrictedProperty = field.get(classz).toString();
                this.restrictedPreferences.add(restrictedProperty);
                this.get(restrictedProperty, null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            for (String key : actualPreferences.keys()) {
                String storedValue;
                if (this.restrictedPreferences.contains(key) || (storedValue = actualPreferences.get(key, null)) == null || !RestrictedFormat.isRestrictedFormat(storedValue)) continue;
                this.userRestrictedPreferences.add(key);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void put(String key, String value) {
        if (this.restrictedPreferences.contains(key) || this.userRestrictedPreferences.contains(key)) {
            try {
                if (!RestrictedFormat.isRestrictedFormat(value)) {
                    throw new Exception("Value not in a retricted format");
                }
                value = RestrictedFormat.retrieveValue(value);
                value = PicketBoxObfuscator.decode(value);
            }
            catch (Exception e) {
                try {
                    value = PicketBoxObfuscator.decode(value);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            try {
                value = PicketBoxObfuscator.encode(value);
            }
            catch (Exception ex2) {
                // empty catch block
            }
            this.actualPreferences.put(key, RestrictedFormat.formatValue(value));
        } else if (RestrictedFormat.isRestrictedFormat(value)) {
            this.userRestrictedPreferences.add(key);
            value = RestrictedFormat.retrieveValue(value);
            try {
                PicketBoxObfuscator.decode(value);
            }
            catch (Exception e) {
                value = PicketBoxObfuscator.encode(value);
            }
            this.actualPreferences.put(key, RestrictedFormat.formatValue(value));
        } else {
            this.actualPreferences.put(key, value);
        }
    }

    @Override
    public String get(String key, String def) {
        String value = this.actualPreferences.get(key, null);
        if (value == null) {
            return def;
        }
        if (this.restrictedPreferences.contains(key) || this.userRestrictedPreferences.contains(key)) {
            try {
                if (RestrictedFormat.isRestrictedFormat(value)) {
                    value = RestrictedFormat.retrieveValue(value);
                    return PicketBoxObfuscator.decode(value);
                }
                throw new Exception("Value not in a restricted format");
            }
            catch (Exception ex) {
                this.put(key, value);
                return value;
            }
        }
        return value;
    }

    @Override
    public void remove(String key) {
        this.actualPreferences.remove(key);
    }

    @Override
    public void clear() throws BackingStoreException {
        this.actualPreferences.clear();
    }

    @Override
    public void putInt(String key, int value) {
        this.actualPreferences.putInt(key, value);
    }

    @Override
    public int getInt(String key, int def) {
        return this.actualPreferences.getInt(key, def);
    }

    @Override
    public void putLong(String key, long value) {
        this.actualPreferences.putLong(key, value);
    }

    @Override
    public long getLong(String key, long def) {
        return this.actualPreferences.getLong(key, def);
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.actualPreferences.putBoolean(key, value);
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        return this.actualPreferences.getBoolean(key, def);
    }

    @Override
    public void putFloat(String key, float value) {
        this.actualPreferences.putFloat(key, value);
    }

    @Override
    public float getFloat(String key, float def) {
        return this.actualPreferences.getFloat(key, def);
    }

    @Override
    public void putDouble(String key, double value) {
        this.actualPreferences.putDouble(key, value);
    }

    @Override
    public double getDouble(String key, double def) {
        return this.actualPreferences.getDouble(key, def);
    }

    @Override
    public void putByteArray(String key, byte[] value) {
        this.actualPreferences.putByteArray(key, value);
    }

    @Override
    public byte[] getByteArray(String key, byte[] def) {
        return this.actualPreferences.getByteArray(key, def);
    }

    @Override
    public String[] keys() throws BackingStoreException {
        return this.actualPreferences.keys();
    }

    @Override
    public String[] childrenNames() throws BackingStoreException {
        return this.actualPreferences.childrenNames();
    }

    @Override
    public Preferences parent() {
        return this.actualPreferences.parent();
    }

    @Override
    public Preferences node(String pathName) {
        return this.actualPreferences.node(pathName);
    }

    @Override
    public boolean nodeExists(String pathName) throws BackingStoreException {
        return this.actualPreferences.nodeExists(pathName);
    }

    @Override
    public void removeNode() throws BackingStoreException {
        this.actualPreferences.removeNode();
    }

    @Override
    public String name() {
        return this.actualPreferences.name();
    }

    @Override
    public String absolutePath() {
        return this.actualPreferences.absolutePath();
    }

    @Override
    public boolean isUserNode() {
        return this.actualPreferences.isUserNode();
    }

    @Override
    public String toString() {
        return this.actualPreferences.toString();
    }

    @Override
    public void flush() throws BackingStoreException {
        this.actualPreferences.flush();
    }

    @Override
    public void sync() throws BackingStoreException {
        this.actualPreferences.sync();
    }

    @Override
    public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
        this.actualPreferences.addPreferenceChangeListener(pcl);
    }

    @Override
    public void removePreferenceChangeListener(PreferenceChangeListener pcl) {
        this.actualPreferences.removePreferenceChangeListener(pcl);
    }

    @Override
    public void addNodeChangeListener(NodeChangeListener ncl) {
        this.actualPreferences.addNodeChangeListener(ncl);
    }

    @Override
    public void removeNodeChangeListener(NodeChangeListener ncl) {
        this.actualPreferences.removeNodeChangeListener(ncl);
    }

    @Override
    public void exportNode(OutputStream os) throws IOException, BackingStoreException {
        this.actualPreferences.exportNode(os);
    }

    @Override
    public void exportSubtree(OutputStream os) throws IOException, BackingStoreException {
        this.actualPreferences.exportSubtree(os);
    }

    public static class RestrictedFormat {
        private static final Pattern RESTRICTED_PATTERN = Pattern.compile("RESTRICTED::.*", 2);
        private static final String RESTRICTED_FORMAT = "RESTRICTED::%s";

        public static boolean isRestrictedFormat(String str) {
            return str != null && RESTRICTED_PATTERN.matcher(str).matches();
        }

        public static String retrieveValue(String value) {
            if (!RestrictedFormat.isRestrictedFormat(value)) {
                return null;
            }
            StringTokenizer tokenizer = new StringTokenizer(value, "::");
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                return tokenizer.nextToken();
            }
            return null;
        }

        public static String formatValue(String value) {
            return String.format(RESTRICTED_FORMAT, value);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Restricted {
    }
}

