/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.subsystems.resourceadapters.AS7ResourceAdapterTags;
import org.jboss.as.connector.subsystems.resourceadapters.CommonIronJacamarParser;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.util.ParserException;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ResourceAdapterParser
extends CommonIronJacamarParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    public void parse(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws Exception {
        int iterate;
        Object adapters = null;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        block1 : switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                switch (Tag.forName(reader.getLocalName())) {
                    case RESOURCE_ADAPTERS: {
                        this.parseResourceAdapters(reader, list, parentAddress);
                        break block1;
                    }
                }
                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void parseResourceAdapters(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.RESOURCE_ADAPTERS) {
                        return;
                    }
                    if (ResourceAdapters.Tag.forName((String)reader.getLocalName()) != ResourceAdapters.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (ResourceAdapters.Tag.forName((String)reader.getLocalName())) {
                        case RESOURCE_ADAPTER: {
                            this.parseResourceAdapter(reader, list, parentAddress);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseResourceAdapter(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        ModelNode raAddress = parentAddress.clone();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        String archiveOrModuleName = null;
        HashMap<String, ModelNode> configPropertiesOperations = new HashMap<String, ModelNode>();
        HashMap<String, ModelNode> connectionDefinitionsOperations = new HashMap<String, ModelNode>();
        HashMap<String, HashMap<String, ModelNode>> cfConfigPropertiesOperations = new HashMap<String, HashMap<String, ModelNode>>();
        HashMap<String, ModelNode> adminObjectsOperations = new HashMap<String, ModelNode>();
        HashMap<String, HashMap<String, ModelNode>> aoConfigPropertiesOperations = new HashMap<String, HashMap<String, ModelNode>>();
        boolean archiveOrModuleMatched = false;
        boolean txSupportMatched = false;
        boolean isXa = false;
        boolean isModule = false;
        String id = null;
        int attributeSize = reader.getAttributeCount();
        block18: for (int i = 0; i < attributeSize; ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case ID: {
                    id = value;
                    continue block18;
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapters.Tag.forName((String)reader.getLocalName()) == ResourceAdapters.Tag.RESOURCE_ADAPTER) {
                        ModelNode configEnv;
                        ModelNode env;
                        if (!archiveOrModuleMatched) {
                            throw new ParserException(bundle.requiredElementMissing(Constants.ARCHIVE.getName(), "resource-adapter"));
                        }
                        if (id != null) {
                            raAddress.add("resource-adapter", id);
                        } else {
                            raAddress.add("resource-adapter", archiveOrModuleName);
                        }
                        raAddress.protect();
                        operation.get("address").set(raAddress);
                        list.add(operation);
                        for (Map.Entry<String, ModelNode> entry : configPropertiesOperations.entrySet()) {
                            env = raAddress.clone();
                            env.add(Constants.CONFIG_PROPERTIES.getName(), entry.getKey());
                            env.protect();
                            entry.getValue().get("address").set(env);
                            list.add(entry.getValue());
                        }
                        for (Map.Entry<String, ModelNode> entry : connectionDefinitionsOperations.entrySet()) {
                            env = raAddress.clone();
                            env.add("connection-definitions", entry.getKey());
                            env.protect();
                            entry.getValue().get("address").set(env);
                            list.add(entry.getValue());
                            HashMap<String, ModelNode> properties = cfConfigPropertiesOperations.get(entry.getKey());
                            if (properties == null) continue;
                            for (Map.Entry<String, ModelNode> configEntry : properties.entrySet()) {
                                configEnv = env.clone();
                                configEnv.add(Constants.CONFIG_PROPERTIES.getName(), configEntry.getKey());
                                configEnv.protect();
                                configEntry.getValue().get("address").set(configEnv);
                                list.add(configEntry.getValue());
                            }
                        }
                        for (Map.Entry<String, ModelNode> entry : adminObjectsOperations.entrySet()) {
                            env = raAddress.clone();
                            env.add("admin-objects", entry.getKey());
                            env.protect();
                            entry.getValue().get("address").set(env);
                            list.add(entry.getValue());
                            HashMap<String, ModelNode> aoProperties = aoConfigPropertiesOperations.get(entry.getKey());
                            if (aoProperties == null) continue;
                            for (Map.Entry<String, ModelNode> configEntry : aoProperties.entrySet()) {
                                configEnv = env.clone();
                                configEnv.add(Constants.CONFIG_PROPERTIES.getName(), configEntry.getKey());
                                configEnv.protect();
                                configEntry.getValue().get("address").set(configEnv);
                                list.add(configEntry.getValue());
                            }
                        }
                        if (isModule) {
                            ModelNode activateOp = new ModelNode();
                            activateOp.get("operation").set("activate");
                            activateOp.get("address").set(raAddress);
                            list.add(activateOp);
                        }
                        return;
                    }
                    if (AS7ResourceAdapterTags.forName(reader.getLocalName()) != AS7ResourceAdapterTags.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (AS7ResourceAdapterTags.forName(reader.getLocalName())) {
                        case ADMIN_OBJECTS: 
                        case CONNECTION_DEFINITIONS: 
                        case BEAN_VALIDATION_GROUPS: {
                            break block3;
                        }
                        case ADMIN_OBJECT: {
                            this.parseAdminObjects(reader, adminObjectsOperations, aoConfigPropertiesOperations);
                            break block3;
                        }
                        case CONNECTION_DEFINITION: {
                            this.parseConnectionDefinitions(reader, connectionDefinitionsOperations, cfConfigPropertiesOperations, isXa);
                            break block3;
                        }
                        case BEAN_VALIDATION_GROUP: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            operation.get(Constants.BEANVALIDATION_GROUPS.getName()).add(Constants.BEANVALIDATIONGROUP.parse(value, (XMLStreamReader)reader));
                            break block3;
                        }
                        case BOOTSTRAP_CONTEXT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.BOOTSTRAP_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block3;
                        }
                        case CONFIG_PROPERTY: {
                            this.parseConfigProperties(reader, configPropertiesOperations);
                            break block3;
                        }
                        case TRANSACTION_SUPPORT: {
                            if (txSupportMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.TRANSACTION_SUPPORT.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_SUPPORT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            isXa = value != null && TransactionSupportEnum.valueOf((String)value) == TransactionSupportEnum.XATransaction;
                            txSupportMatched = true;
                            break block3;
                        }
                        case ARCHIVE: {
                            if (archiveOrModuleMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.ARCHIVE.getXmlName()));
                            }
                            archiveOrModuleName = this.rawElementText((XMLStreamReader)reader);
                            Constants.ARCHIVE.parseAndSetParameter(archiveOrModuleName, operation, (XMLStreamReader)reader);
                            archiveOrModuleMatched = true;
                            break block3;
                        }
                        case MODULE: {
                            if (archiveOrModuleMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.MODULE.getXmlName()));
                            }
                            String moduleId = this.rawAttributeText((XMLStreamReader)reader, "id");
                            String moduleSlot = this.rawAttributeText((XMLStreamReader)reader, "slot", "main");
                            archiveOrModuleName = moduleId + ":" + moduleSlot;
                            Constants.MODULE.parseAndSetParameter(archiveOrModuleName, operation, (XMLStreamReader)reader);
                            isModule = true;
                            archiveOrModuleMatched = true;
                            break block3;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    public static enum Attribute {
        UNKNOWN(null),
        ID("id");

        private String name;
        private static final Map<String, Attribute> MAP;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        Attribute value(String v) {
            this.name = v;
            return this;
        }

        public static Attribute forName(String localName) {
            Attribute element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Attribute> map = new HashMap<String, Attribute>();
            for (Attribute element : Attribute.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    public static enum Tag {
        UNKNOWN(null),
        RESOURCE_ADAPTERS("resource-adapters");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

