/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.Namespace;
import org.jboss.as.connector.util.AbstractParser;
import org.jboss.as.connector.util.ParserException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.Driver;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.v11.DataSource;
import org.jboss.jca.common.api.metadata.ds.v11.DsPool;
import org.jboss.jca.common.api.metadata.ds.v11.DsXaPool;
import org.jboss.jca.common.api.metadata.ds.v11.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class DsParser
extends AbstractParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    public void parse(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws Exception {
        int iterate;
        Object dataSources = null;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        block1 : switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                switch (Tag.forName(reader.getLocalName())) {
                    case DATASOURCES: {
                        this.parseDataSources(reader, list, parentAddress);
                        break block1;
                    }
                }
                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void parseDataSources(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        boolean driversMatched = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.DATASOURCES) {
                        return;
                    }
                }
                case 1: {
                    switch (DataSources.Tag.forName((String)reader.getLocalName())) {
                        case DATASOURCE: {
                            switch (Namespace.forUri(reader.getNamespaceURI())) {
                                case DATASOURCES_1_0: 
                                case DATASOURCES_1_1: {
                                    this.parseDataSource_1_0(reader, list, parentAddress);
                                    break block0;
                                }
                                case DATASOURCES_1_2: {
                                    this.parseDataSource_1_2(reader, list, parentAddress);
                                }
                            }
                            break block0;
                        }
                        case XA_DATASOURCE: {
                            switch (Namespace.forUri(reader.getNamespaceURI())) {
                                case DATASOURCES_1_0: 
                                case DATASOURCES_1_1: 
                                case DATASOURCES_1_2: {
                                    this.parseXADataSource_1_0(reader, list, parentAddress);
                                }
                            }
                            break block0;
                        }
                        case DRIVERS: {
                            driversMatched = true;
                            break block0;
                        }
                        case DRIVER: {
                            this.parseDriver(reader, list, parentAddress);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDriver(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        ModelNode driverAddress = parentAddress.clone();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        String driverName = null;
        block15: for (Driver.Attribute attribute : Driver.Attribute.values()) {
            switch (attribute) {
                case NAME: {
                    driverName = this.rawAttributeText((XMLStreamReader)reader, Constants.DRIVER_NAME.getXmlName());
                    Constants.DRIVER_NAME.parseAndSetParameter(driverName, operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case MAJOR_VERSION: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.DRIVER_MAJOR_VERSION.getXmlName());
                    Constants.DRIVER_MAJOR_VERSION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case MINOR_VERSION: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.DRIVER_MINOR_VERSION.getXmlName());
                    Constants.DRIVER_MINOR_VERSION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case MODULE: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.DRIVER_MODULE_NAME.getXmlName());
                    Constants.DRIVER_MODULE_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block15;
                }
            }
        }
        driverAddress.add("jdbc-driver", driverName);
        driverAddress.protect();
        operation.get("address").set(driverAddress);
        boolean driverClassMatched = false;
        boolean xaDatasourceClassMatched = false;
        boolean datasourceClassMatched = false;
        while (reader.hasNext()) {
            block6 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DRIVER) {
                        list.add(operation);
                        return;
                    }
                    if (Driver.Tag.forName((String)reader.getLocalName()) != Driver.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Driver.Tag.forName((String)reader.getLocalName())) {
                        case DATASOURCE_CLASS: {
                            if (datasourceClassMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.DRIVER_DATASOURCE_CLASS_NAME.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_DATASOURCE_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            datasourceClassMatched = true;
                            break block6;
                        }
                        case XA_DATASOURCE_CLASS: {
                            if (xaDatasourceClassMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            xaDatasourceClassMatched = true;
                            break block6;
                        }
                        case DRIVER_CLASS: {
                            if (driverClassMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.DRIVER_CLASS_NAME.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            driverClassMatched = true;
                            break block6;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseXADataSource_1_0(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String value;
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        boolean enabled = Defaults.ENABLED;
        boolean persistEnabled = true;
        int count = reader.getAttributeCount();
        block27: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            XaDataSource.Attribute attribute = XaDataSource.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block27;
                    enabled = Boolean.parseBoolean(value);
                    persistEnabled = true;
                    continue block27;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, Constants.JNDI_NAME.getXmlName());
                    Constants.JNDI_NAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block27;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block27;
                }
                case USE_JAVA_CONTEXT: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block27;
                    Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block27;
                }
                case SPY: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block27;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block27;
                }
                case USE_CCM: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block27;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block27;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("xa-data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> xadatasourcePropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.XA_DATASOURCE) {
                        list.add(operation);
                        list.addAll(xadatasourcePropertiesOperations);
                        if (enabled) {
                            ModelNode enableOperation = new ModelNode();
                            enableOperation.get("operation").set("enable");
                            enableOperation.get("address").set(dsAddress);
                            enableOperation.get("persistent").set(persistEnabled);
                            list.add(enableOperation);
                        }
                        return;
                    }
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) != XaDataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XaDataSource.Tag.forName((String)reader.getLocalName())) {
                        case XA_DATASOURCE_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value2 = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.XADATASOURCE_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.XADATASOURCE_PROPERTY_VALUE.parseAndSetParameter(value2, configOperation, (XMLStreamReader)reader);
                            xadatasourcePropertiesOperations.add(configOperation);
                            break block8;
                        }
                        case XA_DATASOURCE_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.XA_DATASOURCE_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case DRIVER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case XA_POOL: {
                            this.parseXaPool(reader, operation);
                            break block8;
                        }
                        case NEW_CONNECTION_SQL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case URL_DELIMITER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case TRANSACTION_ISOLATION: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block8;
                        }
                        case SECURITY: {
                            this.parseDsSecurity(reader, operation);
                            break block8;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block8;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block8;
                        }
                        case VALIDATION: {
                            this.parseValidationSetting(reader, operation);
                            break block8;
                        }
                        case RECOVERY: {
                            this.parseRecovery(reader, operation);
                            break block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDsSecurity(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        boolean securityDomainMatched = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return;
                    }
                    if (DsSecurity.Tag.forName((String)reader.getLocalName()) != DsSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    DsSecurity.Tag tag = DsSecurity.Tag.forName((String)reader.getLocalName());
                    switch (tag) {
                        case PASSWORD: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.PASSWORD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USER_NAME: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.USERNAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            if (securityDomainMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.SECURITY_DOMAIN.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SECURITY_DOMAIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            securityDomainMatched = true;
                            break block0;
                        }
                        case REAUTH_PLUGIN: {
                            this.parseExtension(reader, tag.getLocalName(), operation, Constants.REAUTH_PLUGIN_CLASSNAME, Constants.REAUTHPLUGIN_PROPERTIES);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDataSource_1_0(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String value;
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        boolean enabled = Defaults.ENABLED;
        boolean persistEnabled = true;
        int count = reader.getAttributeCount();
        block29: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            DataSource.Attribute attribute = DataSource.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block29;
                    enabled = Boolean.parseBoolean(value);
                    persistEnabled = true;
                    continue block29;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, Constants.JNDI_NAME.getXmlName());
                    Constants.JNDI_NAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block29;
                }
                case USE_JAVA_CONTEXT: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block29;
                    Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                case SPY: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block29;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                case USE_CCM: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block29;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                case JTA: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.JTA.getXmlName());
                    if (value == null) continue block29;
                    Constants.JTA.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> configPropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block9 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DATASOURCE) {
                        list.add(operation);
                        list.addAll(configPropertiesOperations);
                        if (enabled) {
                            ModelNode enableOperation = new ModelNode();
                            enableOperation.get("operation").set("enable");
                            enableOperation.get("address").set(dsAddress);
                            enableOperation.get("persistent").set(persistEnabled);
                            list.add(enableOperation);
                        }
                        return;
                    }
                    if (DataSource.Tag.forName((String)reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DataSource.Tag.forName((String)reader.getLocalName())) {
                        case CONNECTION_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value2 = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.CONNECTION_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.CONNECTION_PROPERTY_VALUE.parseAndSetParameter(value2, configOperation, (XMLStreamReader)reader);
                            configPropertiesOperations.add(configOperation);
                            break block9;
                        }
                        case CONNECTION_URL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.CONNECTION_URL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case DRIVER_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case DATASOURCE_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case DRIVER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case POOL: {
                            this.parsePool(reader, operation);
                            break block9;
                        }
                        case NEW_CONNECTION_SQL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case URL_DELIMITER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case TRANSACTION_ISOLATION: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case SECURITY: {
                            this.parseDsSecurity(reader, operation);
                            break block9;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block9;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block9;
                        }
                        case VALIDATION: {
                            this.parseValidationSetting(reader, operation);
                            break block9;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDataSource_1_2(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String value;
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        boolean enabled = Defaults.ENABLED;
        boolean persistEnabled = true;
        int count = reader.getAttributeCount();
        block30: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            DataSource.Attribute attribute = DataSource.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block30;
                    enabled = Boolean.parseBoolean(value);
                    persistEnabled = true;
                    continue block30;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, Constants.JNDI_NAME.getXmlName());
                    Constants.JNDI_NAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block30;
                }
                case USE_JAVA_CONTEXT: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block30;
                    Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case SPY: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block30;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case USE_CCM: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block30;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case JTA: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.JTA.getXmlName());
                    if (value == null) continue block30;
                    Constants.JTA.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                case CONNECTABLE: {
                    value = this.rawAttributeText((XMLStreamReader)reader, Constants.CONNECTABLE.getXmlName());
                    if (value == null) continue block30;
                    Constants.CONNECTABLE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block30;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> configPropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block10 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DATASOURCE) {
                        list.add(operation);
                        list.addAll(configPropertiesOperations);
                        if (enabled) {
                            ModelNode enableOperation = new ModelNode();
                            enableOperation.get("operation").set("enable");
                            enableOperation.get("address").set(dsAddress);
                            enableOperation.get("persistent").set(persistEnabled);
                            list.add(enableOperation);
                        }
                        return;
                    }
                    if (DataSource.Tag.forName((String)reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DataSource.Tag.forName((String)reader.getLocalName())) {
                        case CONNECTION_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value2 = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.CONNECTION_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.CONNECTION_PROPERTY_VALUE.parseAndSetParameter(value2, configOperation, (XMLStreamReader)reader);
                            configPropertiesOperations.add(configOperation);
                            break block10;
                        }
                        case CONNECTION_URL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.CONNECTION_URL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case DRIVER_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case DATASOURCE_CLASS: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case DRIVER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case POOL: {
                            this.parsePool(reader, operation);
                            break block10;
                        }
                        case NEW_CONNECTION_SQL: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case URL_DELIMITER: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case TRANSACTION_ISOLATION: {
                            value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block10;
                        }
                        case SECURITY: {
                            this.parseDsSecurity(reader, operation);
                            break block10;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block10;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block10;
                        }
                        case VALIDATION: {
                            this.parseValidationSetting(reader, operation);
                            break block10;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parsePool(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.POOL) {
                        return;
                    }
                    if (DsPool.Tag.forName((String)reader.getLocalName()) != DsPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DsPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PREFILL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case ALLOW_MULTIPLE_USERS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.ALLOW_MULTIPLE_USERS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case UNKNOWN: {
                            throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseXaPool(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.XA_POOL) {
                        return;
                    }
                    if (DsXaPool.Tag.forName((String)reader.getLocalName()) != DsXaPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DsXaPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PREFILL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case ALLOW_MULTIPLE_USERS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.ALLOW_MULTIPLE_USERS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case INTERLEAVING: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.INTERLEAVING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case IS_SAME_RM_OVERRIDE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SAME_RM_OVERRIDE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case NO_TX_SEPARATE_POOLS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.NO_TX_SEPARATE_POOL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PAD_XID: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.PAD_XID.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case WRAP_XA_RESOURCE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.WRAP_XA_RESOURCE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseRecovery(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        block11: for (Recovery.Attribute attribute : Recovery.Attribute.values()) {
            switch (attribute) {
                case NO_RECOVERY: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.NO_RECOVERY.getXmlName());
                    Constants.NO_RECOVERY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.RECOVERY) {
                        return;
                    }
                    if (Recovery.Tag.forName((String)reader.getLocalName()) != Recovery.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    Recovery.Tag tag = Recovery.Tag.forName((String)reader.getLocalName());
                    switch (tag) {
                        case RECOVER_CREDENTIAL: {
                            this.parseCredential(reader, operation);
                            break block3;
                        }
                        case RECOVER_PLUGIN: {
                            this.parseExtension(reader, tag.getLocalName(), operation, Constants.RECOVER_PLUGIN_CLASSNAME, Constants.RECOVER_PLUGIN_PROPERTIES);
                            break block3;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseCredential(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY || Recovery.Tag.forName((String)reader.getLocalName()) == Recovery.Tag.RECOVER_CREDENTIAL) {
                        return;
                    }
                    if (Credential.Tag.forName((String)reader.getLocalName()) != Credential.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Credential.Tag.forName((String)reader.getLocalName())) {
                        case PASSWORD: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_PASSWORD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USER_NAME: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_USERNAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_SECURITY_DOMAIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseValidationSetting(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.VALIDATION) {
                        return;
                    }
                    if (Validation.Tag.forName((String)reader.getLocalName()) != Validation.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    Validation.Tag currTag = Validation.Tag.forName((String)reader.getLocalName());
                    switch (currTag) {
                        case BACKGROUND_VALIDATION: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION_MILLIS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case CHECK_VALID_CONNECTION_SQL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.CHECK_VALID_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case EXCEPTION_SORTER: {
                            this.parseExtension(reader, currTag.getLocalName(), operation, Constants.EXCEPTION_SORTER_CLASSNAME, Constants.EXCEPTION_SORTER_PROPERTIES);
                            break block0;
                        }
                        case STALE_CONNECTION_CHECKER: {
                            this.parseExtension(reader, currTag.getLocalName(), operation, Constants.STALE_CONNECTION_CHECKER_CLASSNAME, Constants.STALE_CONNECTION_CHECKER_PROPERTIES);
                            break block0;
                        }
                        case USE_FAST_FAIL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case VALIDATE_ON_MATCH: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.VALIDATE_ON_MATCH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case VALID_CONNECTION_CHECKER: {
                            this.parseExtension(reader, currTag.getLocalName(), operation, Constants.VALID_CONNECTION_CHECKER_CLASSNAME, Constants.VALID_CONNECTION_CHECKER_PROPERTIES);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseTimeOutSettings(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.TIMEOUT) {
                        return;
                    }
                    if (TimeOut.Tag.forName((String)reader.getLocalName()) != TimeOut.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (TimeOut.Tag.forName((String)reader.getLocalName())) {
                        case ALLOCATION_RETRY: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.ALLOCATION_RETRY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY_WAIT_MILLIS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.ALLOCATION_RETRY_WAIT_MILLIS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case BLOCKING_TIMEOUT_MILLIS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case IDLE_TIMEOUT_MINUTES: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case QUERY_TIMEOUT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.QUERY_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SET_TX_QUERY_TIMEOUT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.SET_TX_QUERY_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_TRY_LOCK: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.USE_TRY_LOCK.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case XA_RESOURCE_TIMEOUT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.XA_RESOURCE_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseStatementSettings(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.STATEMENT) {
                        return;
                    }
                    if (Statement.Tag.forName((String)reader.getLocalName()) != Statement.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Statement.Tag.forName((String)reader.getLocalName())) {
                        case PREPARED_STATEMENT_CACHE_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.PREPARED_STATEMENTS_CACHE_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case TRACK_STATEMENTS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRACK_STATEMENTS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SHARE_PREPARED_STATEMENTS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.SHARE_PREPARED_STATEMENTS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    public static enum Tag {
        UNKNOWN(null),
        DATASOURCES("datasources");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

