/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters.deployment;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setThreadContextClassLoader(final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    static AccessControlContext getAccessControlContext() {
        return AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

            @Override
            public AccessControlContext run() {
                return AccessController.getContext();
            }
        });
    }
}

