/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.remote.ClientConnectionOpenListener;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteConnectionProviderMXBean;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.remote.ServerConnectionOpenListener;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.NetworkServerProvider;
import org.xnio.BufferAllocator;
import org.xnio.Buffers;
import org.xnio.ByteBufferSlicePool;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Result;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.FramedMessageChannel;
import org.xnio.ssl.XnioSsl;

final class RemoteConnectionProvider
extends AbstractHandleableCloseable<ConnectionProvider>
implements ConnectionProvider {
    private static final boolean USE_POOLING;
    private final ProviderInterface providerInterface = new ProviderInterface();
    private final Xnio xnio;
    private final XnioWorker xnioWorker;
    private final ConnectionProviderContext connectionProviderContext;
    private final Pool<ByteBuffer> messageBufferPool;
    private final Pool<ByteBuffer> framingBufferPool;
    private final boolean sslEnabled;
    private final Collection<Cancellable> pendingInboundConnections = Collections.synchronizedSet(new HashSet());
    private final Set<RemoteConnectionHandler> handlers = Collections.synchronizedSet(new HashSet());
    private final MBeanServer server;
    private final ObjectName objectName;

    RemoteConnectionProvider(OptionMap optionMap, ConnectionProviderContext connectionProviderContext) throws IOException {
        super(connectionProviderContext.getExecutor());
        this.xnio = connectionProviderContext.getXnio();
        this.sslEnabled = optionMap.get(Options.SSL_ENABLED, true);
        this.xnioWorker = connectionProviderContext.getXnioWorker();
        this.connectionProviderContext = connectionProviderContext;
        int messageBufferSize = optionMap.get(RemotingOptions.RECEIVE_BUFFER_SIZE, 8192);
        this.messageBufferPool = USE_POOLING ? new ByteBufferSlicePool(BufferAllocator.BYTE_BUFFER_ALLOCATOR, messageBufferSize, optionMap.get(RemotingOptions.BUFFER_REGION_SIZE, messageBufferSize * 2)) : Buffers.allocatedBufferPool((BufferAllocator)BufferAllocator.BYTE_BUFFER_ALLOCATOR, (int)messageBufferSize);
        int framingBufferSize = messageBufferSize + 4;
        this.framingBufferPool = USE_POOLING ? new ByteBufferSlicePool(BufferAllocator.BYTE_BUFFER_ALLOCATOR, framingBufferSize, optionMap.get(RemotingOptions.BUFFER_REGION_SIZE, framingBufferSize * 2)) : Buffers.allocatedBufferPool((BufferAllocator)BufferAllocator.BYTE_BUFFER_ALLOCATOR, (int)framingBufferSize);
        MBeanServer server = null;
        ObjectName objectName = null;
        try {
            server = ManagementFactory.getPlatformMBeanServer();
            objectName = new ObjectName("jboss.remoting.handler", "name", connectionProviderContext.getEndpoint().getName() + "-" + this.hashCode());
            server.registerMBean(new RemoteConnectionProviderMXBean(){

                @Override
                public void dumpConnectionState() {
                    RemoteConnectionProvider.this.doDumpConnectionState();
                }

                @Override
                public String dumpConnectionStateToString() {
                    return RemoteConnectionProvider.this.doGetConnectionState();
                }
            }, objectName);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.server = server;
        this.objectName = objectName;
    }

    private void doDumpConnectionState() {
        StringBuilder b = new StringBuilder();
        this.doGetConnectionState(b);
        RemoteLogger.log.info(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetConnectionState(StringBuilder b) {
        b.append("Connection state for ").append(this).append(':').append('\n');
        Set<RemoteConnectionHandler> set = this.handlers;
        synchronized (set) {
            for (RemoteConnectionHandler handler : this.handlers) {
                handler.dumpState(b);
            }
        }
    }

    private String doGetConnectionState() {
        StringBuilder b = new StringBuilder();
        this.doGetConnectionState(b);
        return b.toString();
    }

    @Override
    public Cancellable connect(SocketAddress bindAddress, SocketAddress destination, final OptionMap connectOptions, Result<ConnectionHandlerFactory> result, final CallbackHandler callbackHandler, XnioSsl xnioSsl) throws IllegalArgumentException {
        IoFuture future;
        if (!this.isOpen()) {
            throw new IllegalStateException("Connection provider is closed");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination address may not be null");
        }
        if (bindAddress != null && destination != null && bindAddress.getClass() != destination.getClass()) {
            throw new IllegalArgumentException("bind and destination addresses must be of the same type");
        }
        RemoteLogger.log.tracef("Attempting to connect to \"%s\" with options %s", destination, connectOptions);
        final FutureResult cancellableResult = new FutureResult();
        cancellableResult.addCancelHandler(new Cancellable(){

            public Cancellable cancel() {
                cancellableResult.setCancelled();
                return this;
            }
        });
        IoFuture returnedFuture = cancellableResult.getIoFuture();
        returnedFuture.addNotifier(IoUtils.resultNotifier(), result);
        boolean sslCapable = this.sslEnabled;
        boolean useSsl = sslCapable && connectOptions.get(Options.SSL_ENABLED, true) && !connectOptions.get(Options.SECURE, false);
        final AccessControlContext accessControlContext = AccessController.getContext();
        ChannelListener<ConnectedStreamChannel> openListener = new ChannelListener<ConnectedStreamChannel>(){

            public void handleEvent(ConnectedStreamChannel channel) {
                try {
                    channel.setOption(Options.TCP_NODELAY, (Object)Boolean.TRUE);
                }
                catch (IOException e) {
                    // empty catch block
                }
                FramedMessageChannel messageChannel = new FramedMessageChannel(channel, RemoteConnectionProvider.this.framingBufferPool.allocate(), RemoteConnectionProvider.this.framingBufferPool.allocate());
                final RemoteConnection remoteConnection = new RemoteConnection((Pool<ByteBuffer>)RemoteConnectionProvider.this.messageBufferPool, channel, (ConnectedMessageChannel)messageChannel, connectOptions, RemoteConnectionProvider.this);
                cancellableResult.addCancelHandler(new Cancellable(){

                    public Cancellable cancel() {
                        RemoteConnectionHandler.sendCloseRequestBody(remoteConnection);
                        remoteConnection.handlePreAuthCloseRequest();
                        return this;
                    }
                });
                if (messageChannel.isOpen()) {
                    remoteConnection.setResult((Result<ConnectionHandlerFactory>)cancellableResult);
                    messageChannel.getWriteSetter().set(remoteConnection.getWriteListener());
                    ClientConnectionOpenListener openListener = new ClientConnectionOpenListener(remoteConnection, RemoteConnectionProvider.this.connectionProviderContext, callbackHandler, accessControlContext, connectOptions);
                    openListener.handleEvent((ConnectedMessageChannel)messageChannel);
                }
            }
        };
        if (useSsl && destination instanceof InetSocketAddress) {
            if (xnioSsl == null) {
                try {
                    xnioSsl = this.xnio.getSslProvider(connectOptions);
                }
                catch (GeneralSecurityException e) {
                    result.setException(RemoteConnectionProvider.sslConfigFailure(e));
                    return IoUtils.nullCancellable();
                }
            }
            future = bindAddress == null ? xnioSsl.connectSsl(this.xnioWorker, (InetSocketAddress)destination, (ChannelListener)openListener, connectOptions) : xnioSsl.connectSsl(this.xnioWorker, (InetSocketAddress)bindAddress, (InetSocketAddress)destination, (ChannelListener)openListener, connectOptions);
        } else {
            future = bindAddress == null ? this.xnioWorker.connectStream(destination, (ChannelListener)openListener, connectOptions) : this.xnioWorker.connectStream(bindAddress, destination, (ChannelListener)openListener, null, connectOptions);
        }
        this.pendingInboundConnections.add((Cancellable)returnedFuture);
        future.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<ConnectedStreamChannel, FutureResult<ConnectionHandlerFactory>>(){

            public void handleFailed(IOException exception, FutureResult<ConnectionHandlerFactory> attachment) {
                attachment.setException(exception);
            }

            public void handleCancelled(FutureResult<ConnectionHandlerFactory> attachment) {
                attachment.setCancelled();
            }
        }, (Object)cancellableResult);
        returnedFuture.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<ConnectionHandlerFactory, IoFuture<ConnectionHandlerFactory>>(){

            public void handleCancelled(IoFuture<ConnectionHandlerFactory> attachment) {
                RemoteConnectionProvider.this.pendingInboundConnections.remove(attachment);
                future.cancel();
            }

            public void handleFailed(IOException exception, IoFuture<ConnectionHandlerFactory> attachment) {
                RemoteConnectionProvider.this.pendingInboundConnections.remove(attachment);
            }

            public void handleDone(ConnectionHandlerFactory data, IoFuture<ConnectionHandlerFactory> attachment) {
                RemoteConnectionProvider.this.pendingInboundConnections.remove(attachment);
            }
        }, (Object)returnedFuture);
        return returnedFuture;
    }

    @Override
    public Object getProviderInterface() {
        return this.providerInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAction() {
        try {
            Cancellable[] cancellables;
            Collection<Cancellable> collection = this.pendingInboundConnections;
            synchronized (collection) {
                cancellables = this.pendingInboundConnections.toArray(new Cancellable[this.pendingInboundConnections.size()]);
                this.pendingInboundConnections.clear();
            }
            for (Cancellable pendingConnection : cancellables) {
                pendingConnection.cancel();
            }
            this.closeComplete();
        }
        finally {
            if (this.server != null && this.objectName != null) {
                try {
                    this.server.unregisterMBean(this.objectName);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    void addConnectionHandler(RemoteConnectionHandler connectionHandler) {
        this.handlers.add(connectionHandler);
    }

    void removeConnectionHandler(RemoteConnectionHandler connectionHandler) {
        this.handlers.remove(connectionHandler);
    }

    @Override
    protected Executor getExecutor() {
        return super.getExecutor();
    }

    private static IOException sslConfigFailure(GeneralSecurityException e) {
        return new IOException("Failed to configure SSL", e);
    }

    public String toString() {
        return String.format("Remoting remote connection provider %x for %s", this.hashCode(), this.connectionProviderContext.getEndpoint());
    }

    static {
        boolean usePooling = true;
        try {
            usePooling = Boolean.parseBoolean(System.getProperty("jboss.remoting.pooled-buffers", "true"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        USE_POOLING = usePooling;
    }

    private final class AcceptListener
    implements ChannelListener<AcceptingChannel<? extends ConnectedStreamChannel>> {
        private final OptionMap serverOptionMap;
        private final ServerAuthenticationProvider serverAuthenticationProvider;
        private final AccessControlContext accessControlContext;

        AcceptListener(OptionMap serverOptionMap, ServerAuthenticationProvider serverAuthenticationProvider, AccessControlContext accessControlContext) {
            this.serverOptionMap = serverOptionMap;
            this.serverAuthenticationProvider = serverAuthenticationProvider;
            this.accessControlContext = accessControlContext;
        }

        public void handleEvent(AcceptingChannel<? extends ConnectedStreamChannel> channel) {
            ConnectedStreamChannel accepted;
            try {
                accepted = (ConnectedStreamChannel)channel.accept();
                if (accepted == null) {
                    return;
                }
            }
            catch (IOException e) {
                RemoteLogger.log.failedToAccept(e);
                return;
            }
            try {
                accepted.setOption(Options.TCP_NODELAY, (Object)Boolean.TRUE);
            }
            catch (IOException e) {
                // empty catch block
            }
            FramedMessageChannel messageChannel = new FramedMessageChannel(accepted, RemoteConnectionProvider.this.framingBufferPool.allocate(), RemoteConnectionProvider.this.framingBufferPool.allocate());
            RemoteConnection connection = new RemoteConnection((Pool<ByteBuffer>)RemoteConnectionProvider.this.messageBufferPool, accepted, (ConnectedMessageChannel)messageChannel, this.serverOptionMap, RemoteConnectionProvider.this);
            ServerConnectionOpenListener openListener = new ServerConnectionOpenListener(connection, RemoteConnectionProvider.this.connectionProviderContext, this.serverAuthenticationProvider, this.serverOptionMap, this.accessControlContext);
            messageChannel.getWriteSetter().set(connection.getWriteListener());
            RemoteLogger.log.tracef("Accepted connection from %s to %s", accepted.getPeerAddress(), accepted.getLocalAddress());
            openListener.handleEvent((ConnectedMessageChannel)messageChannel);
        }
    }

    final class ProviderInterface
    implements NetworkServerProvider {
        ProviderInterface() {
        }

        @Override
        public AcceptingChannel<? extends ConnectedStreamChannel> createServer(SocketAddress bindAddress, OptionMap optionMap, ServerAuthenticationProvider authenticationProvider, XnioSsl xnioSsl) throws IOException {
            AcceptingChannel result;
            AccessControlContext accessControlContext = AccessController.getContext();
            boolean sslCapable = RemoteConnectionProvider.this.sslEnabled;
            AcceptListener acceptListener = new AcceptListener(optionMap, authenticationProvider, accessControlContext);
            if (sslCapable && optionMap.get(Options.SSL_ENABLED, true)) {
                if (xnioSsl == null) {
                    try {
                        xnioSsl = RemoteConnectionProvider.this.xnio.getSslProvider(optionMap);
                    }
                    catch (GeneralSecurityException e) {
                        throw RemoteConnectionProvider.sslConfigFailure(e);
                    }
                }
                result = xnioSsl.createSslTcpServer(RemoteConnectionProvider.this.xnioWorker, (InetSocketAddress)bindAddress, (ChannelListener)acceptListener, optionMap);
            } else {
                result = RemoteConnectionProvider.this.xnioWorker.createStreamServer(bindAddress, (ChannelListener)acceptListener, optionMap);
            }
            RemoteConnectionProvider.this.addCloseHandler(new CloseHandler<ConnectionProvider>(){

                @Override
                public void handleClose(ConnectionProvider closed, IOException exception) {
                    IoUtils.safeClose((Closeable)result);
                }
            });
            result.resumeAccepts();
            return result;
        }
    }
}

