/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.adduser.AbstractValidationState;
import org.jboss.as.domain.management.security.adduser.ConfirmationChoice;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.ErrorState;
import org.jboss.as.domain.management.security.adduser.PreModificationState;
import org.jboss.as.domain.management.security.adduser.PromptNewUserState;
import org.jboss.as.domain.management.security.adduser.PromptPasswordState;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;
import org.jboss.as.domain.management.security.password.PasswordCheckResult;
import org.jboss.as.domain.management.security.password.PasswordCheckUtil;

public class ValidatePasswordState
extends AbstractValidationState {
    private final StateValues stateValues;
    private final ConsoleWrapper theConsole;

    public ValidatePasswordState(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
    }

    @Override
    protected Collection<State> getValidationStates() {
        ArrayList<State> validationStates = new ArrayList<State>(2);
        validationStates.add(this.getUsernameMatchState());
        validationStates.add(this.getDetailedCheckState());
        return validationStates;
    }

    private State getRetryState() {
        return this.stateValues.isSilentOrNonInteractive() ? null : new PromptNewUserState(this.theConsole, this.stateValues);
    }

    private State getUsernameMatchState() {
        return new State(){

            @Override
            public State execute() {
                if (Arrays.equals(ValidatePasswordState.this.stateValues.getUserName().toCharArray(), ValidatePasswordState.this.stateValues.getPassword())) {
                    return new ErrorState(ValidatePasswordState.this.theConsole, DomainManagementMessages.MESSAGES.usernamePasswordMatch(), ValidatePasswordState.this.getRetryState(), ValidatePasswordState.this.stateValues);
                }
                return ValidatePasswordState.this;
            }
        };
    }

    private State getDetailedCheckState() {
        return new State(){

            @Override
            public State execute() {
                PasswordCheckResult result = PasswordCheckUtil.INSTANCE.check(false, ValidatePasswordState.this.stateValues.getUserName(), new String(ValidatePasswordState.this.stateValues.getPassword()));
                if (result.getResult() == PasswordCheckResult.Result.WARN && !ValidatePasswordState.this.stateValues.isSilentOrNonInteractive()) {
                    String message = result.getMessage();
                    String prompt = DomainManagementMessages.MESSAGES.sureToSetPassword(new String(ValidatePasswordState.this.stateValues.getPassword()));
                    PromptNewUserState noState = new PromptNewUserState(ValidatePasswordState.this.theConsole, ValidatePasswordState.this.stateValues);
                    return new ConfirmationChoice(ValidatePasswordState.this.theConsole, message, prompt, (State)ValidatePasswordState.this, (State)noState);
                }
                if (result.getResult() == PasswordCheckResult.Result.REJECT) {
                    return new ErrorState(ValidatePasswordState.this.theConsole, result.getMessage(), ValidatePasswordState.this.getRetryState());
                }
                return ValidatePasswordState.this;
            }
        };
    }

    @Override
    protected State getSuccessState() {
        return this.stateValues.isInteractive() ? new PromptPasswordState(this.theConsole, this.stateValues, true) : new PreModificationState(this.theConsole, this.stateValues);
    }
}

