/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.AuthenticationMechanism;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.sasl.callback.VerifyPasswordCallback;

public class UserLdapCallbackHandler
implements Service<CallbackHandlerService>,
CallbackHandlerService {
    private static final String SERVICE_SUFFIX = "ldap";
    public static final String DEFAULT_USER_DN = "dn";
    private final InjectedValue<ConnectionManager> connectionManager = new InjectedValue();
    private final String baseDn;
    private final String usernameAttribute;
    private final String advancedFilter;
    private final boolean recursive;
    private final String userDn;
    private final boolean allowEmptyPassword;
    private final boolean shareConnection;
    protected final int searchTimeLimit = 10000;

    public UserLdapCallbackHandler(String baseDn, String userNameAttribute, String advancedFilter, boolean recursive, String userDn, boolean allowEmptyPassword, boolean shareConnection) {
        this.baseDn = baseDn;
        if (userNameAttribute == null && advancedFilter == null) {
            throw DomainManagementMessages.MESSAGES.oneOfRequired("username-attribute", "advanced-filter");
        }
        this.usernameAttribute = userNameAttribute;
        this.advancedFilter = advancedFilter;
        this.recursive = recursive;
        this.userDn = userDn;
        this.allowEmptyPassword = allowEmptyPassword;
        this.shareConnection = shareConnection;
    }

    @Override
    public AuthenticationMechanism getPreferredMechanism() {
        return AuthenticationMechanism.PLAIN;
    }

    @Override
    public Set<AuthenticationMechanism> getSupplementaryMechanisms() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        return Collections.singletonMap("org.jboss.as.domain.management.verify_password_callback_supported", Boolean.TRUE.toString());
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return new LdapCallbackHandler(sharedState);
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ConnectionManager> getConnectionManagerInjector() {
        return this.connectionManager;
    }

    private void safeClose(Context context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void safeClose(NamingEnumeration ne) {
        if (ne != null) {
            try {
                ne.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{UserLdapCallbackHandler.SERVICE_SUFFIX});
        }
    }

    private class LdapCallbackHandler
    implements CallbackHandler {
        private final Map<String, Object> sharedState;

        private LdapCallbackHandler(Map<String, Object> sharedState) {
            this.sharedState = sharedState;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks.length == 1 && callbacks[0] instanceof AuthorizeCallback) {
                String authorizationId;
                AuthorizeCallback acb = (AuthorizeCallback)callbacks[0];
                String authenticationId = acb.getAuthenticationID();
                boolean authorized = authenticationId.equals(authorizationId = acb.getAuthorizationID());
                if (!authorized) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Checking 'AuthorizeCallback', authorized=false, authenticationID=%s, authorizationID=%s.", authenticationId, authorizationId);
                }
                acb.setAuthorized(authorized);
                return;
            }
            ConnectionManager connectionManager = (ConnectionManager)UserLdapCallbackHandler.this.connectionManager.getValue();
            VerifyPasswordCallback verifyPasswordCallback = null;
            String username = null;
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    username = ((NameCallback)current).getDefaultName();
                    continue;
                }
                if (current instanceof RealmCallback) continue;
                if (current instanceof VerifyPasswordCallback) {
                    verifyPasswordCallback = (VerifyPasswordCallback)current;
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
            if (username == null || username.length() == 0) {
                DomainManagementLogger.SECURITY_LOGGER.trace("No username or 0 length username supplied.");
                throw DomainManagementMessages.MESSAGES.noUsername();
            }
            if (verifyPasswordCallback == null) {
                DomainManagementLogger.SECURITY_LOGGER.trace("No password supplied.");
                throw DomainManagementMessages.MESSAGES.noPassword();
            }
            String password = verifyPasswordCallback.getPassword();
            if (password == null || !UserLdapCallbackHandler.this.allowEmptyPassword && password.length() == 0) {
                DomainManagementLogger.SECURITY_LOGGER.trace("No password or 0 length password supplied.");
                throw DomainManagementMessages.MESSAGES.noPassword();
            }
            DirContext searchContext = null;
            DirContext userContext = null;
            NamingEnumeration<SearchResult> searchEnumeration = null;
            try {
                Attribute dn;
                searchContext = (DirContext)connectionManager.getConnection();
                SearchControls searchControls = new SearchControls();
                if (UserLdapCallbackHandler.this.recursive) {
                    DomainManagementLogger.SECURITY_LOGGER.trace("Performing recursive search");
                    searchControls.setSearchScope(2);
                } else {
                    DomainManagementLogger.SECURITY_LOGGER.trace("Performing single level search");
                    searchControls.setSearchScope(1);
                }
                searchControls.setReturningAttributes(new String[]{UserLdapCallbackHandler.this.userDn});
                searchControls.setTimeLimit(10000);
                Object[] filterArguments = new Object[]{username};
                String filter = UserLdapCallbackHandler.this.usernameAttribute != null ? "(" + UserLdapCallbackHandler.this.usernameAttribute + "={0})" : UserLdapCallbackHandler.this.advancedFilter;
                DomainManagementLogger.SECURITY_LOGGER.tracef("Searching for user '%s' using filter '%s'.", username, filter);
                searchEnumeration = searchContext.search(UserLdapCallbackHandler.this.baseDn, filter, filterArguments, searchControls);
                if (!searchEnumeration.hasMore()) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found in directory.", username);
                    throw DomainManagementMessages.MESSAGES.userNotFoundInDirectory(username);
                }
                String distinguishedUserDN = null;
                SearchResult result = searchEnumeration.next();
                Attributes attributes = result.getAttributes();
                if (attributes != null && (dn = attributes.get(UserLdapCallbackHandler.this.userDn)) != null) {
                    distinguishedUserDN = (String)dn.get();
                }
                if (distinguishedUserDN == null) {
                    if (result.isRelative()) {
                        distinguishedUserDN = result.getName() + ("".equals(UserLdapCallbackHandler.this.baseDn) ? "" : "," + UserLdapCallbackHandler.this.baseDn);
                    } else {
                        String name = result.getName();
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Can't follow referral for authentication: %s", name);
                        throw DomainManagementMessages.MESSAGES.nameNotFound(name);
                    }
                }
                DomainManagementLogger.SECURITY_LOGGER.tracef("DN '%s' found for user '%s'", distinguishedUserDN, username);
                try {
                    userContext = (DirContext)connectionManager.getConnection(distinguishedUserDN, password);
                    if (userContext != null) {
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Password verified for user '%s'", username);
                        verifyPasswordCallback.setVerified(true);
                        this.sharedState.put(LdapEntry.class.getName(), new LdapEntry(username, distinguishedUserDN));
                    }
                }
                catch (Exception e) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Password verification failed for user '%s'", username);
                    verifyPasswordCallback.setVerified(false);
                }
            }
            catch (Exception e) {
                try {
                    DomainManagementLogger.SECURITY_LOGGER.trace("Unable to verify identity.", e);
                    throw DomainManagementMessages.MESSAGES.cannotPerformVerification(e);
                }
                catch (Throwable throwable) {
                    UserLdapCallbackHandler.this.safeClose(searchEnumeration);
                    this.safeClose(verifyPasswordCallback, searchContext);
                    UserLdapCallbackHandler.this.safeClose(userContext);
                    throw throwable;
                }
            }
            UserLdapCallbackHandler.this.safeClose(searchEnumeration);
            this.safeClose(verifyPasswordCallback, searchContext);
            UserLdapCallbackHandler.this.safeClose(userContext);
        }

        private void safeClose(VerifyPasswordCallback vpc, DirContext context) {
            if (UserLdapCallbackHandler.this.shareConnection && context != null && vpc != null && vpc.isVerified()) {
                this.sharedState.put(DirContext.class.getName(), context);
            } else {
                UserLdapCallbackHandler.this.safeClose(context);
            }
        }
    }
}

