/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.AuthenticationMechanism;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.UserNotFoundException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class UserDomainCallbackHandler
implements Service<CallbackHandlerService>,
CallbackHandlerService,
CallbackHandler {
    private static final String SERVICE_SUFFIX = "users";
    private final String realm;
    private volatile ModelNode userDomain;

    public UserDomainCallbackHandler(String realm, ModelNode userDomain) {
        this.realm = realm;
        this.setUserDomain(userDomain);
    }

    void setUserDomain(ModelNode userDomain) {
        this.userDomain = userDomain == null || !userDomain.isDefined() ? new ModelNode().setEmptyObject() : userDomain.clone();
    }

    @Override
    public AuthenticationMechanism getPreferredMechanism() {
        return AuthenticationMechanism.DIGEST;
    }

    @Override
    public Set<AuthenticationMechanism> getSupplementaryMechanisms() {
        return Collections.singleton(AuthenticationMechanism.PLAIN);
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        return Collections.singletonMap("org.jboss.as.domain.management.digest.plain_text", Boolean.TRUE.toString());
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return this;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public UserDomainCallbackHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        ModelNode userMap = this.userDomain;
        LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
        String userName = null;
        ModelNode user = null;
        for (Callback current : callbacks) {
            if (current instanceof AuthorizeCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)current;
                userName = nameCallback.getDefaultName();
                if (!userMap.get("user").hasDefined(userName)) continue;
                user = userMap.get(new String[]{"user", userName});
                continue;
            }
            if (current instanceof PasswordCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof RealmCallback) {
                String realm = ((RealmCallback)current).getDefaultText();
                if (this.realm.equals(realm)) continue;
                throw DomainManagementMessages.MESSAGES.invalidRealm(realm, this.realm);
            }
            throw new UnsupportedCallbackException(current);
        }
        for (Callback current : toRespondTo) {
            if (current instanceof AuthorizeCallback) {
                AuthorizeCallback acb = (AuthorizeCallback)current;
                boolean authorized = acb.getAuthenticationID().equals(acb.getAuthorizationID());
                if (!authorized) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Checking 'AuthorizeCallback', authorized=false, authenticationID=%s, authorizationID=%s.", acb.getAuthenticationID(), acb.getAuthorizationID());
                }
                acb.setAuthorized(authorized);
                continue;
            }
            if (!(current instanceof PasswordCallback)) continue;
            if (user == null) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found.", userName);
                throw new UserNotFoundException(userName);
            }
            String password = user.require("password").asString();
            ((PasswordCallback)current).setPassword(password.toCharArray());
        }
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{UserDomainCallbackHandler.SERVICE_SUFFIX});
        }
    }
}

