/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.msc.service.StartException;

final class JKSKeystore {
    private KeyStore keyStore;
    private final String path;
    private long lastModificationTime;
    private final char[] keystorePassword;
    private final char[] keyPassword;
    private final String alias;

    private JKSKeystore(String path, char[] keystorePassword) {
        this.path = path;
        this.keystorePassword = keystorePassword;
        this.keyPassword = null;
        this.alias = null;
        this.lastModificationTime = 0L;
    }

    private JKSKeystore(String path, char[] keystorePassword, char[] keyPassword, String alias) {
        this.path = path;
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
        this.alias = alias;
        this.lastModificationTime = 0L;
    }

    static JKSKeystore newKeyStore(String path, char[] keystorePassword, char[] keyPassword, String alias) {
        return new JKSKeystore(path, keystorePassword, keyPassword, alias);
    }

    static JKSKeystore newTrustStore(String path, char[] keystorePassword) {
        return new JKSKeystore(path, keystorePassword);
    }

    boolean isModified() {
        long lastModified = new File(this.path).lastModified();
        if (lastModified > this.lastModificationTime) {
            return true;
        }
        return lastModified == 0L;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void load() throws StartException {
        FileInputStream fis = null;
        try {
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            if (new File(this.path).exists()) {
                fis = new FileInputStream(this.path);
                loadedKeystore.load(fis, this.keystorePassword);
            } else {
                loadedKeystore.load(null);
            }
            if (this.alias == null) {
                this.setKeyStore(loadedKeystore);
            } else {
                KeyStore newKeystore = KeyStore.getInstance("JKS");
                newKeystore.load(null);
                KeyStore.PasswordProtection passParam = new KeyStore.PasswordProtection(this.keyPassword == null ? this.keystorePassword : this.keyPassword);
                KeyStore.Entry entry = loadedKeystore.getEntry(this.alias, passParam);
                newKeystore.setEntry(this.alias, entry, passParam);
                this.setKeyStore(newKeystore);
            }
            this.lastModificationTime = new File(this.path).lastModified();
            this.safeClose(fis);
            return;
        }
        catch (KeyStoreException e) {
            try {
                throw DomainManagementMessages.MESSAGES.unableToStart(e);
                catch (NoSuchAlgorithmException e2) {
                    throw DomainManagementMessages.MESSAGES.unableToStart(e2);
                }
                catch (CertificateException e3) {
                    throw DomainManagementMessages.MESSAGES.unableToStart(e3);
                }
                catch (IOException e4) {
                    throw DomainManagementMessages.MESSAGES.unableToStart(e4);
                }
                catch (UnrecoverableEntryException e5) {
                    throw DomainManagementMessages.MESSAGES.unableToStart(e5);
                }
            }
            catch (Throwable throwable) {
                this.safeClose(fis);
                throw throwable;
            }
        }
    }

    KeyStore getKeyStore() {
        return this.keyStore;
    }

    private void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    private void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

