/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.jboss.as.domain.management.AuthenticationMechanism;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ClientCertCallbackHandler
implements Service<CallbackHandlerService>,
CallbackHandlerService,
CallbackHandler {
    private static final String SERVICE_SUFFIX = "client_cert";

    ClientCertCallbackHandler() {
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    @Override
    public AuthenticationMechanism getPreferredMechanism() {
        return AuthenticationMechanism.CLIENT_CERT;
    }

    @Override
    public Set<AuthenticationMechanism> getSupplementaryMechanisms() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return this;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback current : callbacks) {
            boolean authorized;
            AuthorizeCallback acb;
            if (current instanceof AuthorizeCallback) {
                acb = (AuthorizeCallback)current;
                authorized = acb.getAuthenticationID().equals(acb.getAuthorizationID());
                if (!authorized) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Checking 'AuthorizeCallback', authorized=false, authenticationID=%s, authorizationID=%s.", acb.getAuthenticationID(), acb.getAuthorizationID());
                }
            } else {
                throw new UnsupportedCallbackException(current);
            }
            acb.setAuthorized(authorized);
        }
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{ClientCertCallbackHandler.SERVICE_SUFFIX});
        }
    }
}

