/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import java.util.Properties;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.SSLContext;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.connections.ldap.SecurityActions;
import org.jboss.as.domain.management.connections.ldap.ThreadLocalSSLSocketFactory;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class LdapConnectionManagerService
implements Service<LdapConnectionManagerService>,
ConnectionManager {
    private static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "controller", "management", "connection_manager"});
    private volatile ModelNode resolvedConfiguration;
    private final InjectedValue<SSLContext> fullSSLContext = new InjectedValue();
    private final InjectedValue<SSLContext> trustSSLContext = new InjectedValue();

    public LdapConnectionManagerService(ModelNode resolvedConfiguration) {
        this.setResolvedConfiguration(resolvedConfiguration);
    }

    void setResolvedConfiguration(ModelNode resolvedConfiguration) {
        resolvedConfiguration.require(LdapConnectionResourceDefinition.URL.getName());
        resolvedConfiguration.require(LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.getName());
        this.resolvedConfiguration = resolvedConfiguration;
    }

    public synchronized void start(StartContext context) throws StartException {
    }

    public synchronized void stop(StopContext context) {
    }

    public synchronized LdapConnectionManagerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<SSLContext> getFullSSLContextInjector() {
        return this.fullSSLContext;
    }

    public InjectedValue<SSLContext> getTrustOnlySSLContextInjector() {
        return this.trustSSLContext;
    }

    @Override
    public Object getConnection() throws Exception {
        ModelNode config = this.resolvedConfiguration;
        return this.getConnection(this.getFullProperties(config), this.getSSLContext(false));
    }

    @Override
    public Object getConnection(String principal, String credential) throws Exception {
        ModelNode config = this.resolvedConfiguration;
        Properties connectionProperties = this.getConnectionOnlyProperties(config);
        connectionProperties.put("java.naming.security.principal", principal);
        connectionProperties.put("java.naming.security.credentials", credential);
        return this.getConnection(connectionProperties, this.getSSLContext(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getConnection(Properties properties, SSLContext sslContext) throws Exception {
        ClassLoader old = SecurityActions.getContextClassLoader();
        try {
            if (sslContext != null) {
                ThreadLocalSSLSocketFactory.setSSLSocketFactory(sslContext.getSocketFactory());
                SecurityActions.setContextClassLoader(ThreadLocalSSLSocketFactory.class);
                properties.put("java.naming.ldap.factory.socket", ThreadLocalSSLSocketFactory.class.getName());
            }
            InitialDirContext initialDirContext = new InitialDirContext(properties);
            return initialDirContext;
        }
        finally {
            if (sslContext != null) {
                ThreadLocalSSLSocketFactory.removeSSLSocketFactory();
            }
            SecurityActions.setContextClassLoader(old);
        }
    }

    private SSLContext getSSLContext(boolean trustOnly) {
        if (trustOnly) {
            return (SSLContext)this.trustSSLContext.getOptionalValue();
        }
        SSLContext sslContext = (SSLContext)this.fullSSLContext.getOptionalValue();
        if (sslContext == null) {
            sslContext = (SSLContext)this.trustSSLContext.getOptionalValue();
        }
        return sslContext;
    }

    private Properties getConnectionOnlyProperties(ModelNode config) {
        Properties result = new Properties();
        String initialContextFactory = config.require("initial-context-factory").asString();
        result.put("java.naming.factory.initial", initialContextFactory);
        String url = config.require("url").asString();
        result.put("java.naming.provider.url", url);
        return result;
    }

    private Properties getFullProperties(ModelNode config) {
        Properties result = this.getConnectionOnlyProperties(config);
        if (config.hasDefined("search-dn")) {
            result.put("java.naming.security.principal", config.require("search-dn").asString());
        }
        if (config.hasDefined("search-credential")) {
            result.put("java.naming.security.credentials", config.require("search-credential").asString());
        }
        return result;
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String connectionName) {
            return BASE_SERVICE_NAME.append(new String[]{connectionName});
        }

        public static ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Injector<ConnectionManager> injector, String connectionName, boolean optional) {
            ServiceBuilder.DependencyType type = optional ? ServiceBuilder.DependencyType.OPTIONAL : ServiceBuilder.DependencyType.REQUIRED;
            sb.addDependency(type, ServiceUtil.createServiceName(connectionName), ConnectionManager.class, injector);
            return sb;
        }
    }
}

