/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.security.SSLContextService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class LdapConnectionAddHandler
extends AbstractAddStepHandler {
    public static final LdapConnectionAddHandler INSTANCE = new LdapConnectionAddHandler();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : LdapConnectionResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            attr.validateAndSet(operation, model);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ModelNode resolvedModel = LdapConnectionAddHandler.createResolvedLdapConfiguration(context, model);
        ServiceTarget serviceTarget = context.getServiceTarget();
        LdapConnectionManagerService connectionManagerService = new LdapConnectionManagerService(resolvedModel);
        ServiceBuilder sb = serviceTarget.addService(LdapConnectionManagerService.ServiceUtil.createServiceName(name), (Service)connectionManagerService).setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (verificationHandler != null) {
            sb.addListener((ServiceListener)verificationHandler);
        }
        if (resolvedModel.hasDefined("security-realm")) {
            String realmName = resolvedModel.require("security-realm").asString();
            SSLContextService.ServiceUtil.addDependency(sb, connectionManagerService.getFullSSLContextInjector(), SecurityRealm.ServiceUtil.createServiceName(realmName), false);
            SSLContextService.ServiceUtil.addDependency(sb, connectionManagerService.getTrustOnlySSLContextInjector(), SecurityRealm.ServiceUtil.createServiceName(realmName), true);
        }
        ServiceController sc = sb.install();
        if (controllers != null) {
            controllers.add(sc);
        }
    }

    static ModelNode createResolvedLdapConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode resolvedModel = new ModelNode();
        for (AttributeDefinition attr : LdapConnectionResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            resolvedModel.get(attr.getName()).set(attr.resolveModelAttribute(context, model));
        }
        return resolvedModel;
    }
}

