/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.factories.GlobalComponentRegistry;
import org.jboss.as.clustering.infinispan.CacheContainer;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;

public class GlobalComponentRegistryService
implements Service<GlobalComponentRegistry> {
    private final Value<CacheContainer> container;
    private volatile GlobalComponentRegistry registry;

    public static final ServiceName getServiceName(String containerName) {
        return EmbeddedCacheManagerService.getServiceName(containerName).append(new String[]{"global-component-registry"});
    }

    public GlobalComponentRegistryService(Value<CacheContainer> container) {
        this.container = container;
    }

    public GlobalComponentRegistry getValue() {
        return this.registry;
    }

    public void start(StartContext context) {
        this.registry = ((CacheContainer)this.container.getValue()).getGlobalComponentRegistry();
        this.registry.start();
    }

    public void stop(StopContext context) {
        CacheContainer container = (CacheContainer)this.container.getValue();
        for (String cacheName : container.getCacheNames()) {
            if (!container.isRunning(cacheName)) continue;
            return;
        }
        this.registry.stop();
        this.registry = null;
    }
}

