/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheMetricsHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheReadAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheWriteAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.LockingResource;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ModuleIdentifierValidator;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class CacheResourceDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition BATCHING = new SimpleAttributeDefinitionBuilder("batching", ModelType.BOOLEAN, true).setXmlName(Attribute.BATCHING.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(false)).build();
    static final SimpleAttributeDefinition CACHE_MODULE = new SimpleAttributeDefinitionBuilder("module", ModelType.STRING, true).setXmlName(Attribute.MODULE.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new ModuleIdentifierValidator(true)).build();
    static final SimpleAttributeDefinition INDEXING = new SimpleAttributeDefinitionBuilder("indexing", ModelType.STRING, true).setXmlName(Attribute.INDEX.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(Indexing.class, true, false)).setDefaultValue(new ModelNode().set(Indexing.NONE.name())).build();
    static final SimpleMapAttributeDefinition INDEXING_PROPERTIES = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("indexing-properties", true).setAllowExpression(true)).setAttributeMarshaller(new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (!(resourceModel = resourceModel.get(attribute.getName())).isDefined()) {
                return;
            }
            for (Property property : resourceModel.asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Element.NAME.getLocalName(), property.getName());
                writer.writeCharacters(property.getValue().asString());
                writer.writeEndElement();
            }
        }
    })).build();
    static final SimpleAttributeDefinition JNDI_NAME = new SimpleAttributeDefinitionBuilder("jndi-name", ModelType.STRING, true).setXmlName(Attribute.JNDI_NAME.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition START = new SimpleAttributeDefinitionBuilder("start", ModelType.STRING, true).setXmlName(Attribute.START.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(StartMode.class, true, false)).setDefaultValue(new ModelNode().set(StartMode.LAZY.name())).build();
    static final SimpleAttributeDefinition STATISTICS_ENABLED = new SimpleAttributeDefinitionBuilder("statistics-enabled", ModelType.BOOLEAN, true).setXmlName(Attribute.STATISTICS_ENABLED.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).setDefaultValue(new ModelNode().set(false)).build();
    static final AttributeDefinition[] CACHE_ATTRIBUTES = new AttributeDefinition[]{BATCHING, CACHE_MODULE, INDEXING, INDEXING_PROPERTIES, JNDI_NAME, START, STATISTICS_ENABLED};
    static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, true).setXmlName(Attribute.NAME.getLocalName()).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition ACTIVATIONS = CacheResourceDefinition.buildMetric("activations", ModelType.STRING);
    static final SimpleAttributeDefinition AVERAGE_READ_TIME = CacheResourceDefinition.buildMetric("average-read-time", ModelType.LONG);
    static final SimpleAttributeDefinition AVERAGE_WRITE_TIME = CacheResourceDefinition.buildMetric("average-write-time", ModelType.LONG);
    static final SimpleAttributeDefinition CACHE_STATUS = CacheResourceDefinition.buildMetric("cache-status", ModelType.STRING);
    static final SimpleAttributeDefinition ELAPSED_TIME = CacheResourceDefinition.buildMetric("elapsed-time", ModelType.LONG);
    static final SimpleAttributeDefinition HIT_RATIO = CacheResourceDefinition.buildMetric("hit-ratio", ModelType.DOUBLE);
    static final SimpleAttributeDefinition HITS = CacheResourceDefinition.buildMetric("hits", ModelType.LONG);
    static final SimpleAttributeDefinition INVALIDATIONS = CacheResourceDefinition.buildMetric("invalidations", ModelType.LONG);
    static final SimpleAttributeDefinition MISSES = CacheResourceDefinition.buildMetric("misses", ModelType.LONG);
    static final SimpleAttributeDefinition NUMBER_OF_ENTRIES = CacheResourceDefinition.buildMetric("number-of-entries", ModelType.INT);
    static final SimpleAttributeDefinition PASSIVATIONS = CacheResourceDefinition.buildMetric("passivations", ModelType.STRING);
    static final SimpleAttributeDefinition READ_WRITE_RATIO = CacheResourceDefinition.buildMetric("read-write-ratio", ModelType.DOUBLE);
    static final SimpleAttributeDefinition REMOVE_HITS = CacheResourceDefinition.buildMetric("remove-hits", ModelType.LONG);
    static final SimpleAttributeDefinition REMOVE_MISSES = CacheResourceDefinition.buildMetric("remove-misses", ModelType.LONG);
    static final SimpleAttributeDefinition STORES = CacheResourceDefinition.buildMetric("stores", ModelType.LONG);
    static final SimpleAttributeDefinition TIME_SINCE_RESET = CacheResourceDefinition.buildMetric("time-since-reset", ModelType.LONG);
    static final AttributeDefinition[] CACHE_METRICS = new AttributeDefinition[]{AVERAGE_READ_TIME, AVERAGE_WRITE_TIME, CACHE_STATUS, ELAPSED_TIME, HIT_RATIO, HITS, INVALIDATIONS, MISSES, NUMBER_OF_ENTRIES, PASSIVATIONS, READ_WRITE_RATIO, REMOVE_HITS, REMOVE_MISSES, STORES, TIME_SINCE_RESET};
    private final ResolvePathHandler resolvePathHandler;

    private static SimpleAttributeDefinition buildMetric(String key, ModelType type) {
        return new SimpleAttributeDefinitionBuilder(key, type, true).setStorageRuntime().build();
    }

    public CacheResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, AbstractAddStepHandler addHandler, OperationStepHandler removeHandler, ResolvePathHandler resolvePathHandler) {
        super(pathElement, descriptionResolver, (OperationStepHandler)addHandler, removeHandler);
        this.resolvePathHandler = resolvePathHandler;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        CacheWriteAttributeHandler writeHandler = new CacheWriteAttributeHandler(CACHE_ATTRIBUTES);
        for (AttributeDefinition attr : CACHE_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, (OperationStepHandler)CacheReadAttributeHandler.INSTANCE, (OperationStepHandler)writeHandler);
        }
        for (AttributeDefinition attr : CACHE_METRICS) {
            resourceRegistration.registerMetric(attr, (OperationStepHandler)CacheMetricsHandler.INSTANCE);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)new LockingResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new TransactionResourceDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new EvictionResourceDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new ExpirationResourceDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new StoreResourceDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new FileStoreResourceDefinition(this.resolvePathHandler));
        resourceRegistration.registerSubModel((ResourceDefinition)new StringKeyedJDBCStoreResourceDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new BinaryKeyedJDBCStoreResourceDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new MixedKeyedJDBCStoreResourceDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new RemoteStoreResourceDefinition());
    }
}

