/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.infinispan.CacheContainer;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class CacheContainerMetricsHandler
extends AbstractRuntimeOnlyHandler {
    public static final CacheContainerMetricsHandler INSTANCE = new CacheContainerMetricsHandler();

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getLastElement().getValue();
        String attrName = operation.require("name").asString();
        ServiceController controller = context.getServiceRegistry(false).getService(EmbeddedCacheManagerService.getServiceName(cacheContainerName));
        boolean started = controller != null && controller.getValue() != null;
        CacheManagerMetrics metric = CacheManagerMetrics.getStat(attrName);
        ModelNode result = new ModelNode();
        if (metric == null) {
            context.getFailureDescription().set(InfinispanMessages.MESSAGES.unknownMetric(attrName));
        } else if (started) {
            CacheContainer cacheManager = (CacheContainer)controller.getValue();
            switch (metric) {
                case CACHE_MANAGER_STATUS: {
                    result.set(cacheManager.getStatus().toString());
                    break;
                }
                case IS_COORDINATOR: {
                    result.set(cacheManager.isCoordinator());
                    break;
                }
                case LOCAL_ADDRESS: {
                    result.set(cacheManager.getAddress() != null ? cacheManager.getAddress().toString() : "N/A");
                    break;
                }
                case COORDINATOR_ADDRESS: {
                    result.set(cacheManager.getCoordinator() != null ? cacheManager.getCoordinator().toString() : "N/A");
                    break;
                }
                case CLUSTER_NAME: {
                    result.set(cacheManager.getClusterName() != null ? cacheManager.getClusterName() : "N/A");
                }
            }
            context.getResult().set(result);
        }
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }

    public static enum CacheManagerMetrics {
        CACHE_MANAGER_STATUS((AttributeDefinition)CacheContainerResourceDefinition.CACHE_MANAGER_STATUS),
        CLUSTER_NAME((AttributeDefinition)CacheContainerResourceDefinition.CLUSTER_NAME),
        IS_COORDINATOR((AttributeDefinition)CacheContainerResourceDefinition.IS_COORDINATOR),
        COORDINATOR_ADDRESS((AttributeDefinition)CacheContainerResourceDefinition.COORDINATOR_ADDRESS),
        LOCAL_ADDRESS((AttributeDefinition)CacheContainerResourceDefinition.LOCAL_ADDRESS);

        private static final Map<String, CacheManagerMetrics> MAP;
        final AttributeDefinition definition;

        private CacheManagerMetrics(AttributeDefinition definition) {
            this.definition = definition;
        }

        public final String toString() {
            return this.definition.getName();
        }

        public static CacheManagerMetrics getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, CacheManagerMetrics>();
            for (CacheManagerMetrics metric : CacheManagerMetrics.values()) {
                MAP.put(metric.toString(), metric);
            }
        }
    }
}

