/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.infinispan.AbstractDelegatingAdvancedCache;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.AbstractDelegatingEmbeddedCacheManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.CacheContainer;

public class DefaultCacheContainer
extends AbstractDelegatingEmbeddedCacheManager
implements CacheContainer {
    private final String defaultCache;

    public DefaultCacheContainer(GlobalConfiguration global, String defaultCache) {
        this((EmbeddedCacheManager)new DefaultCacheManager(global, null, false), defaultCache);
    }

    public DefaultCacheContainer(GlobalConfiguration global, Configuration config, String defaultCache) {
        this((EmbeddedCacheManager)new DefaultCacheManager(global, config, false), defaultCache);
    }

    public DefaultCacheContainer(EmbeddedCacheManager container, String defaultCache) {
        super(container);
        this.defaultCache = defaultCache;
    }

    @Deprecated
    public org.infinispan.config.Configuration defineConfiguration(String cacheName, org.infinispan.config.Configuration configurationOverride) {
        return this.cm.defineConfiguration(this.getCacheName(cacheName), configurationOverride);
    }

    @Deprecated
    public org.infinispan.config.Configuration defineConfiguration(String cacheName, String templateCacheName, org.infinispan.config.Configuration configurationOverride) {
        return this.cm.defineConfiguration(this.getCacheName(cacheName), this.getCacheName(templateCacheName), configurationOverride);
    }

    public Configuration defineConfiguration(String cacheName, Configuration configuration) {
        return this.cm.defineConfiguration(this.getCacheName(cacheName), configuration);
    }

    public <K, V> Cache<K, V> getCache() {
        return this.getCache(this.defaultCache);
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, true);
    }

    public <K, V> Cache<K, V> getCache(String cacheName, boolean start) {
        Cache cache = this.cm.getCache(this.getCacheName(cacheName), start);
        return cache != null ? new DelegatingCache(cache) : null;
    }

    public Set<String> getCacheNames() {
        HashSet<String> names = new HashSet<String>(this.cm.getCacheNames());
        names.add(this.defaultCache);
        return names;
    }

    public boolean isDefaultRunning() {
        return this.cm.isRunning(this.defaultCache);
    }

    public boolean isRunning(String cacheName) {
        return this.cm.isRunning(this.getCacheName(cacheName));
    }

    public boolean cacheExists(String cacheName) {
        return this.cm.cacheExists(this.getCacheName(cacheName));
    }

    public void removeCache(String cacheName) {
        this.cm.removeCache(this.getCacheName(cacheName));
    }

    public EmbeddedCacheManager startCaches(String ... names) {
        LinkedHashSet<String> cacheNames = new LinkedHashSet<String>();
        for (String name : names) {
            cacheNames.add(this.getCacheName(name));
        }
        this.cm.startCaches(cacheNames.toArray(new String[cacheNames.size()]));
        return this;
    }

    private String getCacheName(String name) {
        return name == null || name.equals("___defaultcache") ? this.defaultCache : name;
    }

    @Override
    public GlobalComponentRegistry getGlobalComponentRegistry() {
        PrivilegedAction<Field> action = new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    Field field = DefaultCacheManager.class.getDeclaredField("globalComponentRegistry");
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        Field field = AccessController.doPrivileged(action);
        try {
            return (GlobalComponentRegistry)field.get(this.cm);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getDefaultCacheName() {
        return this.defaultCache;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.cm.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName();
    }

    class DelegatingCache<K, V>
    extends AbstractDelegatingAdvancedCache<K, V> {
        DelegatingCache(AdvancedCache<K, V> cache) {
            super(cache, new AbstractDelegatingAdvancedCache.AdvancedCacheWrapper<K, V>(){

                public AdvancedCache<K, V> wrap(AdvancedCache<K, V> cache) {
                    return new DelegatingCache(cache);
                }
            });
        }

        DelegatingCache(Cache<K, V> cache) {
            this(cache.getAdvancedCache());
        }

        public EmbeddedCacheManager getCacheManager() {
            return DefaultCacheContainer.this;
        }

        public boolean equals(Object object) {
            return object == this || object == this.cache;
        }

        public int hashCode() {
            return this.cache.hashCode();
        }
    }
}

