/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.event.AjaxEvent;
import org.richfaces.component.UIPanelMenu;
import org.richfaces.component.UIPanelMenuGroup;
import org.richfaces.renderkit.PanelMenuRendererBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelMenuGroupRenderer
extends PanelMenuRendererBase {
    protected Class<UIPanelMenuGroup> getComponentClass() {
        return UIPanelMenuGroup.class;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        UIPanelMenuGroup group = (UIPanelMenuGroup)component;
        if (requestMap.containsKey("panelMenuState" + clientId)) {
            Object property = requestMap.get("panelMenuState" + clientId);
            if (property.equals("opened")) {
                group.setSubmittedValue("true");
            } else if (property.equals("closed")) {
                group.setSubmittedValue("false");
            }
        }
        if (this.isSubmitted(context, component)) {
            new ActionEvent(component).queue();
            if ("ajax".equals(this.getItemMode(component))) {
                new AjaxEvent(component).queue();
            }
        }
    }

    public void insertImage(FacesContext context, UIComponent component, Object data) throws IOException {
        String from = (String)data;
        String align = "";
        UIPanelMenu panelMenu = this.findMenu(component);
        boolean isTopLevel = this.isTopLevel(component);
        align = isTopLevel ? panelMenu.getIconGroupTopPosition() : panelMenu.getIconGroupPosition();
        if (align.equalsIgnoreCase(from)) {
            this.image(context, component, from + "Icon" + component.getClientId(context));
        } else {
            String iconType = "spacer";
            String imageSrc = this.getIconByType(iconType, isTopLevel, context, component);
            this.drawIcon(context.getResponseWriter(), iconType, imageSrc, component, from + "Icon" + component.getClientId(context), false);
        }
    }

    private void image(FacesContext context, UIComponent component, String id) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIPanelMenu panelMenu = this.findMenu(component);
        if (panelMenu == null) {
            return;
        }
        UIPanelMenuGroup panelMenuGroup = (UIPanelMenuGroup)component;
        boolean isTopLevel = this.isTopLevel((UIComponent)panelMenuGroup);
        boolean isOpened = this.isOpened(context, component);
        String defaultIconNodeClosed = null;
        if (isTopLevel) {
            if (panelMenuGroup.isDisabled()) {
                defaultIconNodeClosed = panelMenu.getIconTopDisableGroup();
                if (defaultIconNodeClosed == null || defaultIconNodeClosed.equals("")) {
                    defaultIconNodeClosed = panelMenu.getIconDisabledGroup();
                }
            } else {
                defaultIconNodeClosed = panelMenu.getIconCollapsedTopGroup();
                if (defaultIconNodeClosed == null || defaultIconNodeClosed.equals("")) {
                    defaultIconNodeClosed = panelMenu.getIconCollapsedGroup();
                }
            }
        } else {
            defaultIconNodeClosed = panelMenuGroup.isDisabled() ? panelMenu.getIconDisabledGroup() : panelMenu.getIconCollapsedGroup();
        }
        if (defaultIconNodeClosed == null || defaultIconNodeClosed.equals("")) {
            defaultIconNodeClosed = "grid";
        }
        String defaultIconNodeOpened = null;
        if (isTopLevel) {
            defaultIconNodeOpened = panelMenu.getIconExpandedTopGroup();
            if (defaultIconNodeOpened == null || defaultIconNodeOpened.equals("")) {
                defaultIconNodeOpened = panelMenu.getIconExpandedGroup();
            }
        } else {
            defaultIconNodeOpened = panelMenu.getIconExpandedGroup();
        }
        if (defaultIconNodeOpened == null || defaultIconNodeOpened.equals("")) {
            defaultIconNodeOpened = "grid";
        }
        String iconExpanded = "";
        String iconCollapsed = "";
        iconExpanded = panelMenuGroup.isDisabled() ? panelMenuGroup.getIconDisabled() : panelMenuGroup.getIconExpanded();
        iconCollapsed = panelMenuGroup.isDisabled() ? panelMenuGroup.getIconDisabled() : panelMenuGroup.getIconCollapsed();
        String icon = null;
        if (isOpened) {
            if (iconExpanded != null && !iconExpanded.equals("")) {
                if (iconExpanded.equals("none")) {
                    return;
                }
                icon = iconExpanded;
            } else {
                icon = defaultIconNodeOpened;
            }
        } else if (iconCollapsed != null && !iconCollapsed.equals("")) {
            if (iconCollapsed.equals("none")) {
                return;
            }
            icon = iconCollapsed;
        } else {
            icon = defaultIconNodeClosed;
        }
        if ("".equals(icon)) {
            icon = "custom";
        }
        String source = this.getIconByType(icon, isTopLevel, context, component);
        boolean drawHidden = false;
        if (source != null && source.trim().length() == 0) {
            source = this.getIconByType("spacer", isTopLevel, context, component);
            drawHidden = true;
        }
        this.drawIcon(writer, icon, source, component, id, drawHidden);
    }

    public String getFullStyleClass(FacesContext context, UIComponent component) {
        StringBuffer classBuffer = new StringBuffer("");
        UIPanelMenuGroup group = (UIPanelMenuGroup)component;
        UIPanelMenu parentMenu = this.findMenu((UIComponent)group);
        if (!parentMenu.isDisabled() && !group.isDisabled()) {
            if (this.calculateLevel((UIComponent)group) == 0) {
                classBuffer.append(parentMenu.getTopGroupClass() + " ");
            } else {
                classBuffer.append(parentMenu.getGroupClass() + " ");
            }
            classBuffer.append(group.getStyleClass());
        } else {
            classBuffer.append(parentMenu.getDisabledGroupClass() + " ").append(group.getDisabledClass());
        }
        return classBuffer.toString();
    }

    public String getFullStyle(FacesContext context, UIComponent component) {
        StringBuffer styleBuffer = new StringBuffer("");
        UIPanelMenuGroup group = (UIPanelMenuGroup)component;
        UIPanelMenu parentMenu = this.findMenu((UIComponent)group);
        if (!group.isDisabled()) {
            if (this.calculateLevel((UIComponent)group) == 0) {
                styleBuffer.append(parentMenu.getTopGroupStyle() + "; ");
            } else {
                styleBuffer.append(parentMenu.getGroupStyle() + "; ");
            }
            styleBuffer.append(group.getStyle());
        } else {
            styleBuffer.append(parentMenu.getDisabledGroupStyle() + "; ").append(group.getDisabledStyle());
        }
        return styleBuffer.toString();
    }

    @Override
    public void insertLabel(FacesContext context, UIComponent component) throws IOException {
        Object label = component.getAttributes().get("label");
        if (label != null) {
            context.getResponseWriter().writeText(label, null);
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        UIPanelMenuGroup group = (UIPanelMenuGroup)component;
        if (group.getConverter() != null) {
            return group.getConverter().getAsObject(context, component, (String)submittedValue);
        }
        return submittedValue;
    }

    public boolean isOpened(FacesContext context, UIComponent component) throws IOException {
        boolean value = false;
        if (component instanceof UIPanelMenuGroup) {
            boolean isChildrenExpanded;
            boolean disabled;
            UIPanelMenuGroup group = (UIPanelMenuGroup)component;
            value = group.isExpanded();
            boolean isParentDisabled = this.isParentDisabled(component);
            boolean bl = disabled = !group.isDisabled() && !isParentDisabled;
            value = value && disabled ? true : (isChildrenExpanded = this.isChildrenExpanded(component)) && disabled;
        }
        return value;
    }

    public String getLabelClass(FacesContext context, UIComponent component) {
        UIPanelMenuGroup group = (UIPanelMenuGroup)component;
        UIPanelMenu parentMenu = this.findMenu((UIComponent)group);
        StringBuffer resClass = new StringBuffer();
        if (!group.isDisabled() && !parentMenu.isDisabled()) {
            if (this.isTopLevel(component)) {
                resClass.append("rich-pmenu-group-self-label rich-pmenu-top-group-self-label");
            } else {
                resClass.append("rich-pmenu-group-self-label");
            }
        }
        return resClass.toString();
    }

    public String getIconClass(FacesContext context, UIComponent component, String align) {
        UIPanelMenuGroup group = (UIPanelMenuGroup)component;
        UIPanelMenu parentMenu = this.findMenu((UIComponent)group);
        String iconClass = "";
        if (!group.isDisabled() && !parentMenu.isDisabled()) {
            String iconClassAttr = ((UIPanelMenuGroup)component).getIconClass();
            if (this.isTopLevel(component) && align.equals(parentMenu.getIconGroupTopPosition())) {
                iconClass = "rich-pmenu-group-self-icon rich-pmenu-top-group-self-icon";
            }
            if (align.equals(parentMenu.getIconGroupPosition()) && iconClassAttr != null) {
                iconClass = iconClass.equals("") ? "rich-pmenu-group-self-icon " + iconClassAttr : iconClass + " " + iconClassAttr;
            }
        }
        return iconClass;
    }

    public String getDivClass(FacesContext context, UIComponent component) {
        String result = "";
        if (this.isTopLevel(component)) {
            result = "rich-pmenu-top-group-div";
        }
        return result;
    }

    public String getTableClass(FacesContext context, UIComponent component) {
        String result = "";
        if (this.isTopLevel(component)) {
            result = "rich-pmenu-top-group ";
        }
        return result;
    }

    @Override
    protected String getName(UIComponent component) {
        return ((UIPanelMenuGroup)component).getName();
    }
}

