/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering;

import java.io.IOException;
import org.jboss.as.clustering.ClassLoaderProvider;
import org.jboss.as.clustering.VersionedMarshallingConfiguration;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;

public class MarshallingContext {
    private final MarshallerFactory factory;
    private final VersionedMarshallingConfiguration configuration;

    public MarshallingContext(MarshallerFactory factory, VersionedMarshallingConfiguration configuration) {
        this.factory = factory;
        this.configuration = configuration;
    }

    public int getCurrentVersion() {
        return this.configuration.getCurrentMarshallingVersion();
    }

    public Unmarshaller createUnmarshaller(int version) throws IOException {
        return this.factory.createUnmarshaller(this.getMarshallingConfiguration(version));
    }

    public Marshaller createMarshaller(int version) throws IOException {
        return this.factory.createMarshaller(this.getMarshallingConfiguration(version));
    }

    public ClassLoader getContextClassLoader(int version) {
        ClassResolver resolver = this.getMarshallingConfiguration(version).getClassResolver();
        return resolver instanceof ClassLoaderProvider ? ((ClassLoaderProvider)resolver).getClassLoader() : null;
    }

    private MarshallingConfiguration getMarshallingConfiguration(int version) {
        return this.configuration.getMarshallingConfiguration(version);
    }
}

