/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.cassandra.util.KeyspaceService;

public class TakeSnapshotOperation {
    private final String R_STRATEGY_KEEP_ALL = "Keep All";
    private final String R_STRATEGY_KEEP_LASTN = "Keep Last N";
    private final String R_STRATEGY_DEL_OLDERN = "Delete Older Than N days";
    private final String D_STRATEGY_DEL = "Delete";
    private final String D_STRATEGY_MOVE = "Move";
    private final KeyspaceService service;
    private final Configuration parameters;
    private final Log log = LogFactory.getLog(TakeSnapshotOperation.class);

    public TakeSnapshotOperation(KeyspaceService service, Configuration parameters) {
        this.service = service;
        this.parameters = parameters;
    }

    public OperationResult invoke() {
        File snapDir;
        OperationResult result = new OperationResult();
        StringBuilder sbResult = new StringBuilder();
        String snapshotName = this.parameters.getSimpleValue("snapshotName", "" + System.currentTimeMillis()).trim();
        if (snapshotName.isEmpty()) {
            result.setErrorMessage("Snapshot Name parameter cannot be an empty string");
            return result;
        }
        String retentionStrategy = this.parameters.getSimpleValue("retentionStrategy", "Keep All");
        Integer count = this.parameters.getSimple("count").getIntegerValue();
        String deletionStrategy = this.parameters.getSimpleValue("deletionStrategy", "Delete");
        String location = this.parameters.getSimpleValue("location");
        if (("Keep Last N".equals(retentionStrategy) || "Delete Older Than N days".equals(retentionStrategy)) && count == null) {
            result.setErrorMessage("Invalid input parameters. Selected Retention Strategy [" + retentionStrategy + "] but 'count' parameter was null");
            return result;
        }
        if ("Move".equals(deletionStrategy) && location == null) {
            result.setErrorMessage("Invalid input parameters. Selected Deletion Strategy [" + deletionStrategy + "] but 'location' parameter was null");
            return result;
        }
        Object[] keyspaces = this.service.getKeyspaces().toArray(new String[0]);
        this.log.info((Object)("Taking snapshot of keyspaces " + Arrays.toString(keyspaces)));
        long startTime = System.currentTimeMillis();
        this.service.takeSnapshot((String[])keyspaces, snapshotName);
        this.log.info((Object)("Snapshot taken in " + (System.currentTimeMillis() - startTime) + "ms"));
        sbResult.append("Snapshot [" + snapshotName + "] was successfully created.");
        if ("Keep All".equals(retentionStrategy)) {
            result.setSimpleResult(sbResult.toString());
            return result;
        }
        if ("Move".equals(deletionStrategy)) {
            File locationDir = new File(location);
            if (!locationDir.exists()) {
                try {
                    if (!locationDir.mkdirs()) {
                        result.setErrorMessage("Location [" + locationDir.getAbsolutePath() + "] did not exist and failed to be created");
                        result.setSimpleResult(sbResult.toString());
                        return result;
                    }
                }
                catch (Exception e) {
                    result.setErrorMessage("Location [" + locationDir.getAbsolutePath() + "] did not exist and failed to be created - " + e.getMessage());
                    result.setSimpleResult(sbResult.toString());
                    return result;
                }
            }
            if (!locationDir.isDirectory()) {
                result.setErrorMessage("Location [" + locationDir.getAbsolutePath() + "] must be directory");
                result.setSimpleResult(sbResult.toString());
                return result;
            }
            if (!locationDir.canWrite()) {
                result.setErrorMessage("Location [" + locationDir.getAbsolutePath() + "] must be writable");
                result.setSimpleResult(sbResult.toString());
                return result;
            }
        }
        List<String> columnFamilyDirs = this.service.getColumnFamilyDirs();
        List<String[]> eligibleSnapshots = this.findEligibleSnapshots(this.service.getKeySpaceDataFileLocations(), columnFamilyDirs, retentionStrategy, count);
        if (eligibleSnapshots.isEmpty()) {
            return result;
        }
        StringBuilder sbMoveOrDeleteErrors = new StringBuilder();
        if ("Delete".equals(deletionStrategy)) {
            this.log.info((Object)("Strategy [" + deletionStrategy + "] is set, deleting " + eligibleSnapshots.size() + " snapshots"));
            sbResult.append("\nDeleting " + eligibleSnapshots.size() + " directories.");
            int deleted = 0;
            for (String[] snapPath : eligibleSnapshots) {
                snapDir = new File(snapPath[0], snapPath[1]);
                this.log.info((Object)("Deleting " + snapDir));
                if (!FileUtils.deleteQuietly((File)snapDir)) {
                    this.log.warn((Object)("Failed to delete " + snapDir.getAbsolutePath()));
                    sbMoveOrDeleteErrors.append("Failed to delete [" + snapDir.getAbsolutePath() + "]\n ");
                    continue;
                }
                ++deleted;
            }
            sbResult.append("\nSuccessfully deleted " + deleted + " directories");
        }
        if ("Move".equals(deletionStrategy)) {
            this.log.info((Object)("Strategy [" + deletionStrategy + "] is set, moving " + eligibleSnapshots.size() + " snapshots"));
            sbResult.append("\nMoving " + eligibleSnapshots.size() + " directories to [" + location + "].");
            int moved = 0;
            for (String[] snapPath : eligibleSnapshots) {
                snapDir = new File(snapPath[0], snapPath[1]);
                File snapTargetDir = new File(location, snapPath[1]);
                this.log.info((Object)("Moving  " + snapDir + " to " + snapTargetDir));
                try {
                    FileUtils.moveDirectoryToDirectory((File)snapDir, (File)snapTargetDir.getParentFile(), (boolean)true);
                    ++moved;
                }
                catch (IOException e) {
                    this.log.warn((Object)("Failed to move directory : " + e.getMessage()));
                    sbMoveOrDeleteErrors.append("Failed to move [" + snapDir.getAbsolutePath() + "] to [" + snapTargetDir.getAbsolutePath() + "]\n ");
                }
            }
            sbResult.append("\nSuccessfully moved " + moved + " directories.");
        }
        if (sbMoveOrDeleteErrors.length() > 0) {
            result.setErrorMessage(sbMoveOrDeleteErrors.toString());
        }
        result.setSimpleResult(sbResult.toString());
        return result;
    }

    private List<String[]> findEligibleSnapshots(String[] dataDirs, List<String> colFamilyDirs, String retentionStrategy, Integer count) {
        ArrayList<String[]> eligibleSnapshots = new ArrayList<String[]>();
        for (String dataRoot : dataDirs) {
            for (String keySpace : colFamilyDirs) {
                String colFamilyDir = keySpace + File.separator + "snapshots";
                File keySpaceDir = new File(dataRoot, colFamilyDir);
                if (!keySpaceDir.exists()) continue;
                File[] snapshots = keySpaceDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                });
                Arrays.sort(snapshots, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return o1.lastModified() > o2.lastModified() ? -1 : 1;
                    }
                });
                if ("Keep Last N".equals(retentionStrategy)) {
                    int index = 0;
                    for (File f : snapshots) {
                        if (index >= count) {
                            eligibleSnapshots.add(new String[]{dataRoot, colFamilyDir + File.separator + f.getName()});
                        }
                        ++index;
                    }
                }
                if (!"Delete Older Than N days".equals(retentionStrategy)) continue;
                long cutOff = System.currentTimeMillis() - (long)count.intValue() * 86400L * 1000L;
                for (File f : snapshots) {
                    if (f.lastModified() >= cutOff) continue;
                    eligibleSnapshots.add(new String[]{dataRoot, colFamilyDir + File.separator + f.getName()});
                }
            }
        }
        return eligibleSnapshots;
    }
}

