/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;

public class KeyspaceService {
    public static final String STORAGE_SERVICE_BEAN = "org.apache.cassandra.db:type=StorageService";
    public static final String REPAIR_OPERATION = "forceTableRepair";
    public static final String REPAIR_PRIMARY_RANGE = "forceTableRepairPrimaryRange";
    public static final String CLEANUP_OPERATION = "forceTableCleanup";
    public static final String COMPACT_OPERATION = "forceTableCompaction";
    public static final String SNAPSHOT_OPERATION = "takeSnapshot";
    public static final String CF_SNAPSHOT_OPERATION = "takeColumnFamilySnapshot";
    private EmsConnection emsConnection;

    public KeyspaceService(EmsConnection emsConnection) {
        this.emsConnection = emsConnection;
    }

    public void repair(String keyspace, String ... columnFamilies) {
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsOperation operation = emsBean.getOperation(REPAIR_OPERATION, new Class[]{String.class, Boolean.TYPE, Boolean.TYPE, String[].class});
        boolean isSequential = false;
        boolean isLocal = true;
        operation.invoke(new Object[]{keyspace, isSequential, isLocal, columnFamilies});
    }

    public void repairPrimaryRange(String keyspace, String ... columnFamilies) {
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsOperation operation = emsBean.getOperation(REPAIR_PRIMARY_RANGE, new Class[]{String.class, Boolean.TYPE, Boolean.TYPE, String[].class});
        boolean isSequential = false;
        boolean isLocal = true;
        operation.invoke(new Object[]{keyspace, isSequential, isLocal, columnFamilies});
    }

    public void cleanup(String keyspace) {
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsOperation operation = emsBean.getOperation(CLEANUP_OPERATION, new Class[]{String.class, String[].class});
        operation.invoke(new Object[]{keyspace, new String[0]});
    }

    public void compact(String keyspace, String ... columnFamilies) {
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsOperation operation = emsBean.getOperation(COMPACT_OPERATION, new Class[]{String.class, String[].class});
        operation.invoke(new Object[]{keyspace, columnFamilies});
    }

    public void takeSnapshot(String keyspace, String snapshotName) {
        this.takeSnapshot(new String[]{keyspace}, snapshotName);
    }

    public void takeSnapshot(String[] keySpaces, String snapshotName) {
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsOperation operation = emsBean.getOperation(SNAPSHOT_OPERATION, new Class[]{String.class, String[].class});
        operation.invoke(new Object[]{snapshotName, keySpaces});
    }

    public String[] getKeySpaceDataFileLocations() {
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsAttribute attribute = emsBean.getAttribute("AllDataFileLocations");
        return (String[])attribute.getValue();
    }

    public List<Object> getKeyspaces() {
        EmsAttribute attribute;
        List value = null;
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        if (emsBean != null && (attribute = emsBean.getAttribute("Keyspaces")) != null) {
            value = (List)attribute.refresh();
        }
        if (value == null) {
            value = new ArrayList();
        }
        return value;
    }

    public List<String> getColumnFamilyDirs() {
        List beans = this.emsConnection.queryBeans("org.apache.cassandra.db:type=ColumnFamilies,*");
        ArrayList<String> dirs = new ArrayList<String>(beans.size());
        for (EmsBean bean : beans) {
            String keySpace = bean.getBeanName().getKeyProperty("keyspace");
            String colFamily = bean.getBeanName().getKeyProperty("columnfamily");
            dirs.add(keySpace + File.separator + colFamily);
        }
        return dirs;
    }

    private EmsBean loadBean(String objectName) {
        EmsBean bean = this.emsConnection.getBean(objectName);
        if (bean == null) {
            this.emsConnection.queryBeans(objectName);
            bean = this.emsConnection.getBean(objectName);
        }
        return bean;
    }
}

