/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.file.FileUtil;
import org.rhq.plugins.cassandra.CassandraNodeComponent;
import org.rhq.plugins.cassandra.ComplexConfigurationResourceComponent;
import org.rhq.plugins.cassandra.KeyspaceComponent;

public class ColumnFamilyComponent
extends ComplexConfigurationResourceComponent {
    private Log log = LogFactory.getLog(ColumnFamilyComponent.class);

    @Override
    public Configuration loadResourceConfiguration() {
        Configuration config = super.loadResourceConfiguration();
        if (this.log.isDebugEnabled()) {
            ResourceContext context = this.getResourceContext();
            this.log.debug((Object)("Loading resource context for column family " + context.getResourceKey()));
        }
        config.put((Property)this.getSnapshotsWithDetails());
        return config;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        String columnFamilyName = this.getResourceContext().getResourceKey();
        if (name.equals("repair")) {
            return this.getParentKeyspace().repairKeyspace(columnFamilyName);
        }
        if (name.equals("compact")) {
            return this.getParentKeyspace().compactKeyspace(columnFamilyName);
        }
        if (name.equals("takeSnapshot")) {
            return this.getParentKeyspace().takeSnapshot(parameters, columnFamilyName);
        }
        if (name.equals("restoreSnapshot")) {
            return this.restoreSnapshot(parameters);
        }
        return super.invokeOperation(name, parameters);
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Updating resource configuration for column family " + this.getResourceContext().getResourceKey()));
        }
        report.getConfiguration().remove("snapshots");
        super.updateResourceConfiguration(report);
    }

    private PropertyList getSnapshotsWithDetails() {
        PropertyList listOfSnapshots = new PropertyList("snapshots");
        KeyspaceComponent parentKeyspace = this.getParentKeyspace();
        PropertyList parentDataFileLocations = parentKeyspace.getKeySpaceDataFileLocations();
        for (Property directory : parentDataFileLocations.getList()) {
            File[] files;
            String directoryName = ((PropertySimple)directory).getStringValue();
            directoryName = directoryName + "/" + this.getResourceContext().getPluginConfiguration().getSimpleValue("name");
            File snapshotDirectory = new File(directoryName = directoryName + "/snapshots");
            if (!snapshotDirectory.exists()) continue;
            for (File individualSnapshot : files = snapshotDirectory.listFiles()) {
                if (!individualSnapshot.isDirectory()) continue;
                PropertyMap snapshotDetails = new PropertyMap("snapshot");
                snapshotDetails.put((Property)new PropertySimple("name", (Object)individualSnapshot.getName()));
                snapshotDetails.put((Property)new PropertySimple("folder", (Object)individualSnapshot.getAbsolutePath()));
                listOfSnapshots.add((Property)snapshotDetails);
            }
        }
        return listOfSnapshots;
    }

    private OperationResult restoreSnapshot(Configuration parameters) {
        OperationResult result = new OperationResult();
        String requestedSnapshotName = parameters.getSimpleValue("snapshotName");
        PropertyList listOfSnapShots = this.getSnapshotsWithDetails();
        String snapshotDirectoryName = null;
        for (Property property : listOfSnapShots.getList()) {
            String snapshotName = ((PropertyMap)property).getSimpleValue("name", null);
            if (!requestedSnapshotName.equals(snapshotName)) continue;
            snapshotDirectoryName = ((PropertyMap)property).getSimpleValue("folder", null);
            break;
        }
        if (snapshotDirectoryName == null) {
            result.setErrorMessage("Restore failed! The snapshot does not exist!");
            return result;
        }
        File snapshotDirectory = new File(snapshotDirectoryName);
        if (!snapshotDirectory.exists() || !snapshotDirectory.isDirectory()) {
            result.setErrorMessage("Restore failed! The snapshot does not exist on disk!");
            return result;
        }
        CassandraNodeComponent node = this.getParentKeyspace().getCassandraNodeComponent();
        node.shutdownNode();
        KeyspaceComponent parentKeyspace = this.getParentKeyspace();
        parentKeyspace.clearCommitLog();
        PropertyList parentDataFileLocations = parentKeyspace.getKeySpaceDataFileLocations();
        for (Property dataFileDirectoryProperty : parentDataFileLocations.getList()) {
            File[] filesToBeRestored;
            String columnFamilyDirectoryName = ((PropertySimple)dataFileDirectoryProperty).getStringValue();
            File columnFamilyDirectory = new File(columnFamilyDirectoryName = columnFamilyDirectoryName + "/" + this.getResourceContext().getPluginConfiguration().getSimpleValue("name"));
            if (!columnFamilyDirectory.exists()) continue;
            File[] originalColumnFamilyDataFiles = columnFamilyDirectory.listFiles();
            if (originalColumnFamilyDataFiles != null) {
                for (File file : originalColumnFamilyDataFiles) {
                    if (!file.isFile()) continue;
                    file.delete();
                }
            }
            if ((filesToBeRestored = snapshotDirectory.listFiles()) == null) continue;
            for (File fileToBeRestored : filesToBeRestored) {
                if (!fileToBeRestored.isFile()) continue;
                File destinationFile = new File(columnFamilyDirectory, fileToBeRestored.getName());
                try {
                    FileUtil.copyFile((File)fileToBeRestored, (File)destinationFile);
                }
                catch (Exception e) {
                    result.setErrorMessage("Restore failed! The file copying process failed!");
                    return result;
                }
            }
        }
        node.startNode();
        result.setSimpleResult("Snapshot restored succesfully...");
        return result;
    }

    private KeyspaceComponent getParentKeyspace() {
        return (KeyspaceComponent)this.getResourceContext().getParentResourceComponent();
    }
}

