/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.SigarException;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.plugins.cassandra.util.KeyspaceService;
import org.rhq.plugins.cassandra.util.TakeSnapshotOperation;
import org.rhq.plugins.jmx.JMXServerComponent;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class CassandraNodeComponent
extends JMXServerComponent<ResourceComponent<?>>
implements OperationFacet {
    private static final Log log = LogFactory.getLog(CassandraNodeComponent.class);
    private String host;
    private ProcessInfo processInfo;

    public void start(ResourceContext context) throws Exception {
        super.start(context);
        this.processInfo = context.getNativeProcess();
        this.host = context.getPluginConfiguration().getSimpleValue("host", "localhost");
    }

    public void stop() {
        this.processInfo = null;
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        long start = System.nanoTime();
        try {
            if (this.isStorageServiceReachable()) {
                AvailabilityType availabilityType = AvailabilityType.UP;
                return availabilityType;
            }
            AvailabilityType availabilityType = AvailabilityType.DOWN;
            return availabilityType;
        }
        finally {
            long totalTimeMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished availability check in " + totalTimeMillis + " ms"));
            }
            if (totalTimeMillis > TimeUnit.SECONDS.toMillis(5L)) {
                log.warn((Object)("Availability check exceeded five seconds. Total time was " + totalTimeMillis + " ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStorageServiceReachable() {
        JMXConnector connector = null;
        try {
            Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
            String url = pluginConfig.getSimpleValue("connectorAddress");
            JMXServiceURL serviceURL = new JMXServiceURL(url);
            connector = JMXConnectorFactory.connect(serviceURL, null);
            MBeanServerConnection serverConnection = connector.getMBeanServerConnection();
            ObjectName storageService = new ObjectName("org.apache.cassandra.db:type=StorageService");
            serverConnection.getAttribute(storageService, "NativeTransportRunning");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to make JMX connection to StorageService", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            block13: {
                if (connector != null) {
                    try {
                        connector.close();
                    }
                    catch (IOException e) {
                        if (!log.isDebugEnabled()) break block13;
                        log.debug((Object)"An error occurred closing the JMX connector", (Throwable)e);
                    }
                }
            }
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals("shutdown")) {
            OperationResult operationResult = this.shutdownNode();
            this.waitForNodeToGoDown();
            return operationResult;
        }
        if (name.equals("start")) {
            return this.startNode();
        }
        if (name.equals("restart")) {
            return this.restartNode();
        }
        if (name.equals("updateSeedsList")) {
            return this.updateSeedsList(parameters);
        }
        if (name.equals("takeSnapshot")) {
            if (this.isStorageServiceReachable()) {
                return new TakeSnapshotOperation(new KeyspaceService(this.getEmsConnection()), parameters).invoke();
            }
            OperationResult result = new OperationResult();
            result.setErrorMessage("Unable to take snaphost, Storage Node is not available");
            return result;
        }
        return null;
    }

    protected OperationResult shutdownNode() {
        ResourceContext context = this.getResourceContext();
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting shutdown operation on " + CassandraNodeComponent.class.getName() + " with resource key " + context.getResourceKey()));
        }
        EmsConnection emsConnection = this.getEmsConnection();
        EmsBean storageService = emsConnection.getBean("org.apache.cassandra.db:type=StorageService");
        Class[] emptyParams = new Class[]{};
        if (log.isDebugEnabled()) {
            log.debug((Object)"Disabling thrift...");
        }
        EmsOperation operation = storageService.getOperation("stopRPCServer", emptyParams);
        operation.invoke((Object[])emptyParams);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Disabling gossip...");
        }
        operation = storageService.getOperation("stopGossiping", emptyParams);
        operation.invoke((Object[])emptyParams);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initiating drain...");
        }
        operation = storageService.getOperation("drain", emptyParams);
        operation.invoke((Object[])emptyParams);
        return this.stopNode();
    }

    protected OperationResult stopNode() {
        ProcessInfo process = this.getResourceContext().getNativeProcess();
        if (process == null) {
            log.warn((Object)"Failed to obtain process info. It appears Cassandra is already shutdown.");
            return new OperationResult("Failed to obtain process info. It appears Cassandra is already shutdown.");
        }
        long pid = process.getPid();
        try {
            process.kill("KILL");
            Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
            File basedir = new File(pluginConfig.getSimpleValue("baseDir"));
            File binDir = new File(basedir, "bin");
            File pidFile = new File(binDir, "cassandra.pid");
            pidFile.delete();
            return new OperationResult("Successfully shut down Cassandra daemon with pid " + pid);
        }
        catch (SigarException e) {
            log.warn((Object)("Failed to shut down Cassandra node with pid " + pid), (Throwable)e);
            OperationResult failure = new OperationResult("Failed to shut down Cassandra node with pid " + pid);
            failure.setErrorMessage(ThrowableUtil.getAllMessages((Throwable)e));
            return failure;
        }
    }

    protected void waitForNodeToGoDown() throws InterruptedException {
        if (OperatingSystem.getInstance().getName().equals("MacOSX")) {
            return;
        }
        ProcessInfo.ProcessInfoSnapshot processInfoSnapshot = this.getProcessInfoSnapshot();
        while (processInfoSnapshot != null && processInfoSnapshot.isRunning()) {
            if (this.getResourceContext().getComponentInvocationContext().isInterrupted()) {
                throw new InterruptedException();
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
            processInfoSnapshot = this.getProcessInfoSnapshot();
        }
    }

    private ProcessInfo.ProcessInfoSnapshot getProcessInfoSnapshot() {
        ProcessInfo.ProcessInfoSnapshot processInfoSnapshot;
        ProcessInfo.ProcessInfoSnapshot processInfoSnapshot2 = processInfoSnapshot = this.processInfo == null ? null : this.processInfo.freshSnapshot();
        if (processInfoSnapshot == null || !processInfoSnapshot.isRunning()) {
            this.processInfo = this.getResourceContext().getNativeProcess();
            processInfoSnapshot = this.processInfo == null ? null : this.processInfo.priorSnaphot();
        }
        return processInfoSnapshot;
    }

    protected OperationResult startNode() {
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        String baseDir = pluginConfig.getSimpleValue("baseDir");
        File binDir = new File(baseDir, "bin");
        if (!this.startScriptExists(binDir)) {
            OperationResult failure = new OperationResult("Failed to start Cassandra daemon");
            failure.setErrorMessage("Start script does not exists");
            return failure;
        }
        ProcessExecution scriptExe = this.getProcessExecution(binDir);
        SystemInfo systemInfo = this.getResourceContext().getSystemInformation();
        ProcessExecutionResults results = systemInfo.executeProcess(scriptExe);
        if (results.getError() == null) {
            return new OperationResult("Successfully started Cassandra daemon");
        }
        OperationResult failure = new OperationResult("Failed to start Cassandra daemon");
        failure.setErrorMessage(ThrowableUtil.getAllMessages((Throwable)results.getError()));
        return failure;
    }

    private boolean startScriptExists(File binDir) {
        File file = new File(binDir, this.getStartScript());
        return file.exists() && !file.isDirectory();
    }

    private ProcessExecution getProcessExecution(File binDir) {
        ProcessExecution scriptExe;
        if (OperatingSystem.getInstance().getName().equals("Win32")) {
            File startScript = new File(binDir, this.getStartScript());
            scriptExe = ProcessExecutionUtility.createProcessExecution((File)startScript);
        } else {
            File startScript = new File("./" + this.getStartScript());
            scriptExe = ProcessExecutionUtility.createProcessExecution((File)startScript);
            scriptExe.setCheckExecutableExists(false);
        }
        scriptExe.setWorkingDirectory(binDir.getAbsolutePath());
        scriptExe.addArguments(Arrays.asList("-p", "cassandra.pid"));
        return scriptExe;
    }

    protected OperationResult restartNode() {
        OperationResult result = this.shutdownNode();
        if (result.getErrorMessage() == null) {
            result = this.startNode();
        }
        return result;
    }

    protected OperationResult updateSeedsList(Configuration params) {
        PropertyList list = params.getList("seedsList");
        List<String> addresses = this.getAddresses(list);
        OperationResult result = new OperationResult();
        try {
            this.updateSeedsList(addresses);
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while updating the seeds list property", (Throwable)e);
            Throwable rootCause = ThrowableUtil.getRootCause((Throwable)e);
            result.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)rootCause));
        }
        return result;
    }

    protected List<String> getAddresses(PropertyList seedsList) {
        ArrayList<String> addresses = new ArrayList<String>();
        for (Property property : seedsList.getList()) {
            PropertySimple simple = (PropertySimple)property;
            addresses.add(simple.getStringValue());
        }
        return addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSeedsList(List<String> seeds) throws IOException {
        block9: {
            ResourceContext context = this.getResourceContext();
            Configuration pluginConfig = context.getPluginConfiguration();
            String yamlProp = pluginConfig.getSimpleValue("yamlConfiguration");
            if (yamlProp == null || yamlProp.isEmpty()) {
                throw new IllegalStateException("Plugin configuration property [yamlConfiguration] is undefined. This property must specify be set and specify the location of cassandra.yaml in order to complete this operation");
            }
            File yamlFile = new File(yamlProp);
            if (!yamlFile.exists()) {
                throw new IllegalStateException("Plug configuration property [yamlConfiguration] has as its value a non-existent file.");
            }
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(options);
            Map cassandraConfig = (Map)yaml.load((InputStream)new FileInputStream(yamlFile));
            List seedProviderList = (List)cassandraConfig.get("seed_provider");
            Map seedProvider = (Map)seedProviderList.get(0);
            List paramsList = (List)seedProvider.get("parameters");
            Map params = (Map)paramsList.get(0);
            params.put("seeds", StringUtil.listToString(seeds));
            File yamlFileBackup = new File(yamlProp + ".bak" + new Date().getTime());
            StreamUtil.copy((InputStream)new FileInputStream(yamlFile), (OutputStream)new FileOutputStream(yamlFileBackup), (boolean)true);
            if (!yamlFile.delete()) {
                String msg = "Failed to delete [" + yamlFile + "] in preparation of writing updated configuration. The " + "changes will be aborted.";
                log.error((Object)msg);
                this.deleteYamlBackupFile(yamlFileBackup);
                throw new IOException(msg);
            }
            FileWriter writer = new FileWriter(yamlFile);
            try {
                yaml.dump((Object)cassandraConfig, (Writer)writer);
                this.deleteYamlBackupFile(yamlFileBackup);
            }
            catch (Exception e) {
                log.error((Object)("An error occurred while trying to write the updated configuration back to " + yamlFile), (Throwable)e);
                log.error((Object)("Reverting changes to " + yamlFile));
                if (yamlFile.delete()) {
                    StreamUtil.copy((InputStream)new FileInputStream(yamlFileBackup), (OutputStream)new FileOutputStream(yamlFile));
                    this.deleteYamlBackupFile(yamlFileBackup);
                    break block9;
                }
                String msg = "Failed updates to " + yamlFile.getName() + " cannot be rolled back. The file cannot be " + "deleted. " + yamlFile + " should be replaced by " + yamlFileBackup;
                log.error((Object)msg);
                throw new IOException(msg);
            }
            finally {
                writer.close();
            }
        }
    }

    private void deleteYamlBackupFile(File yamlBackup) {
        if (!yamlBackup.delete()) {
            log.warn((Object)("Failed to delete Cassandra configuration backup file [" + yamlBackup + "]. This file " + "should be deleted."));
        }
    }

    private String getStartScript() {
        ResourceContext context = this.getResourceContext();
        SystemInfo systemInfo = context.getSystemInformation();
        if (systemInfo.getOperatingSystemType() == OperatingSystemType.WINDOWS) {
            return "cassandra.bat";
        }
        return "cassandra";
    }

    public String getHost() {
        return this.host;
    }
}

