/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.storage.installer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.Deployer;
import org.rhq.cassandra.DeploymentException;
import org.rhq.cassandra.DeploymentOptions;
import org.rhq.cassandra.DeploymentOptionsFactory;
import org.rhq.cassandra.util.ConfigEditor;
import org.rhq.core.db.DbUtil;
import org.rhq.core.db.upgrade.StorageNodeVersionColumnUpgrader;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.core.util.obfuscation.PicketBoxObfuscator;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.storage.installer.StorageInstallerError;
import org.rhq.storage.installer.StorageInstallerException;
import org.rhq.storage.installer.StorageProperty;

public class StorageInstaller {
    private static final String STORAGE_BASEDIR = "rhq-storage";
    private static final int RPC_PORT = 9160;
    public static final int STATUS_NO_ERRORS = 0;
    public static final int STATUS_STORAGE_NOT_RUNNING = 1;
    public static final int STATUS_FAILED_TO_VERIFY_NODE_UP = 2;
    public static final int STATUS_INVALID_FILE_PERMISSIONS = 3;
    public static final int STATUS_DATA_DIR_NOT_EMPTY = 4;
    public static final int STATUS_SHOW_USAGE = 100;
    public static final int STATUS_INVALID_UPGRADE = 5;
    public static final int STATUS_DEPLOYMENT_ERROR = 6;
    public static final int STATUS_IO_ERROR = 7;
    public static final int STATUS_JMX_PORT_CONFLICT = 8;
    public static final int STATUS_CQL_PORT_CONFLICT = 9;
    public static final int STATUS_GOSSIP_PORT_CONFLICT = 10;
    public static final int STATUS_UNKNOWN_HOST = 11;
    public static final int STATUS_VERSION_STAMP_ERROR = 12;
    static final String STORAGE_LOG_FILE_PATH = "../../logs/rhq-storage.log";
    static final String DEFAULT_COMMIT_LOG_DIR = "../../../rhq-data/commit_log";
    static final String DEFAULT_DATA_DIR = "../../../rhq-data/data";
    static final String DEFAULT_SAVED_CACHES_DIR = "../../../rhq-data/saved_caches";
    private static final Log log = LogFactory.getLog(StorageInstaller.class);
    private Options options;
    private File serverBasedir;
    private File storageBasedir;
    private int defaultJmxPort = 7299;
    private int defaultCqlPort = 9142;
    private int defaultGossipPort = 7100;
    private String defaultHeapSize = "512M";
    private String defaultHeapNewSize = "128M";

    public StorageInstaller() {
        String basedir = System.getProperty("rhq.server.basedir");
        this.serverBasedir = new File(basedir);
        this.storageBasedir = new File(basedir, STORAGE_BASEDIR);
        Option hostname = new Option("n", StorageProperty.HOSTNAME.property(), true, "The hostname or IP address on which the node will listen for requests. Note that if a hostname is specified, the IP address is used. Defaults to the IP address of the local host (which depending on hostname configuration may not be localhost).");
        hostname.setArgName("HOSTNAME");
        Option seeds = new Option("s", StorageProperty.SEEDS.property(), true, "A comma-delimited list of hostnames or IP addresses that serve as contact points. Nodes use this list to find each other and to learn the cluster topology. It does not need to specify all nodes in the cluster. Defaults to this node's hostname.");
        seeds.setArgName("SEEDS");
        Option jmxPortOption = new Option("j", StorageProperty.JMX_PORT.property(), true, "The port on which to listen for JMX connections. Defaults to " + this.defaultJmxPort + ".");
        jmxPortOption.setArgName("PORT");
        Option cqlPortOption = new Option("c", StorageProperty.CQL_PORT.property(), true, "The port on which to listen for client requests. Defaults to " + this.defaultCqlPort);
        cqlPortOption.setArgName("PORT");
        Option gossipPortOption = new Option(null, StorageProperty.GOSSIP_PORT.property(), true, "The port on which to listen for requests  from other nodes. Defaults to " + this.defaultGossipPort);
        gossipPortOption.setArgName("PORT");
        Option startOption = new Option(null, "start", true, "Start the storage node after installing it on disk. Defaults to true.");
        startOption.setArgName("true|false");
        Option checkStatus = new Option(null, "check-status", true, "Check the node status to verify that it is up after starting it. This option is ignored if the start option is not set. Defaults to true.");
        checkStatus.setArgName("true|false");
        Option commitLogOption = new Option(null, StorageProperty.COMMITLOG.property(), true, "The directory where the storage node keeps commit log files. Defaults to " + this.getDefaultCommitLogDir() + ".");
        commitLogOption.setArgName("DIR");
        Option dataDirOption = new Option(null, StorageProperty.DATA.property(), true, "The directory where the storage node keeps data files. Defaults to " + this.getDefaultDataDir() + ".");
        dataDirOption.setArgName("DIR");
        Option savedCachesDirOption = new Option(null, StorageProperty.SAVED_CACHES.property(), true, "The directory where the storage node keeps saved cache files. Defaults to " + this.getDefaultSavedCachesDir() + ".");
        savedCachesDirOption.setArgName("DIR");
        Option basedirOption = new Option(null, "dir", true, "The directory where the storage node will be installed The default directory will be " + this.storageBasedir);
        Option heapSizeOption = new Option(null, StorageProperty.HEAP_SIZE.property(), true, "The value to use for both the min and max heap. This value is passed directly to the -Xms and -Xmx options of the Java executable. Defaults to " + this.defaultHeapSize);
        Option heapNewSizeOption = new Option(null, StorageProperty.HEAP_NEW_SIZE.property(), true, "The value to use for the new generation of the heap. This value is passed directly to the -Xmn option of the Java executable. Defaults to " + this.defaultHeapNewSize);
        Option noVersionStampOption = new Option(null, "no-version-stamp", false, "If specified the DB will not be updated with a version stamp. This is an advanced option and should not generally be used.");
        Option stackSizeOption = new Option(null, StorageProperty.STACK_SIZE.property(), true, "The value to use for the thread stack size. This value is passed directly to the -Xss option of the Java executable.");
        Option undoOption = new Option(null, "undo", true, "An internally used option to undo work performed in a failed upgrade. The directory where the existing RHQ server is installed.");
        undoOption.setArgName("RHQ_SERVER_DIR");
        Option upgradeOption = new Option(null, "upgrade", true, "Upgrades an existing storage node. The directory where the existing RHQ server is installed.");
        upgradeOption.setArgName("RHQ_SERVER_DIR");
        Option verifyDataDirsEmptyOption = new Option(null, StorageProperty.VERIFY_DATA_DIRS_EMPTY.property(), true, "Will cause the installer to abort if any of the data directories is not empty. Defaults to true.");
        this.options = new Options().addOption(new Option("h", "help", false, "Show this message.")).addOption(hostname).addOption(seeds).addOption(jmxPortOption).addOption(startOption).addOption(checkStatus).addOption(commitLogOption).addOption(dataDirOption).addOption(savedCachesDirOption).addOption(cqlPortOption).addOption(gossipPortOption).addOption(basedirOption).addOption(heapSizeOption).addOption(heapNewSizeOption).addOption(noVersionStampOption).addOption(stackSizeOption).addOption(upgradeOption).addOption(undoOption).addOption(verifyDataDirsEmptyOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(org.apache.commons.cli.CommandLine cmdLine) throws Exception {
        File binDir;
        File oldServerPropsFile;
        InstallerInfo installerInfo;
        if (cmdLine.hasOption("h")) {
            this.printUsage();
            return 100;
        }
        boolean isUpgrade = cmdLine.hasOption("upgrade");
        boolean isUndo = cmdLine.hasOption("undo");
        boolean noStamp = cmdLine.hasOption("no-version-stamp");
        File fromDir = null;
        try {
            if (isUpgrade) {
                fromDir = new File(cmdLine.getOptionValue("upgrade", ""));
                installerInfo = this.upgrade(fromDir);
            } else {
                if (isUndo) {
                    fromDir = new File(cmdLine.getOptionValue("undo", ""));
                    this.undo(fromDir, noStamp);
                    return 0;
                }
                installerInfo = this.install(cmdLine);
            }
        }
        catch (StorageInstallerError e) {
            log.error((Object)"An unexpected error occurred", (Throwable)e);
            log.error((Object)"The storage installer will exit due to previous errors");
            return e.getErrorCode();
        }
        catch (StorageInstallerException e) {
            log.warn((Object)e.getMessage());
            log.warn((Object)"The storage installer will exit due to previous errors");
            return e.getErrorCode();
        }
        log.info((Object)"Updating rhq-server.properties...");
        PropertiesFileUpdate serverPropertiesUpdater = this.getServerProperties();
        Properties properties = new Properties();
        properties.setProperty("rhq.storage.nodes", installerInfo.hostname);
        properties.setProperty(StorageProperty.CQL_PORT.property(), Integer.toString(installerInfo.cqlPort));
        properties.setProperty(StorageProperty.GOSSIP_PORT.property(), Integer.toString(installerInfo.gossipPort));
        if (isUpgrade && ((oldServerPropsFile = new File(fromDir, "bin/rhq-server.properties")).exists() || !noStamp)) {
            Properties oldProperties = new Properties();
            FileInputStream oldServerPropsFileInputStream = new FileInputStream(oldServerPropsFile);
            try {
                oldProperties.load(oldServerPropsFileInputStream);
                properties.setProperty("rhq.server.database.connection-url", oldProperties.getProperty("rhq.server.database.connection-url"));
                properties.setProperty("rhq.server.database.user-name", oldProperties.getProperty("rhq.server.database.user-name"));
                properties.setProperty("rhq.server.database.password", oldProperties.getProperty("rhq.server.database.password"));
            }
            finally {
                oldServerPropsFileInputStream.close();
            }
        }
        serverPropertiesUpdater.update(properties);
        Properties dbProperties = serverPropertiesUpdater.loadExistingProperties();
        if (isUpgrade && !noStamp) {
            try {
                String version = StorageInstaller.class.getPackage().getImplementationVersion();
                StorageInstaller.stampStorageNodeVersion(dbProperties, installerInfo.hostname, version);
            }
            catch (Exception e) {
                log.error((Object)"Failed to update version stamp", (Throwable)e);
                return 12;
            }
        }
        if (this.isWindows()) {
            File basedir = new File(System.getProperty("rhq.server.basedir"));
            basedir = null == basedir ? installerInfo.basedir.getParentFile() : basedir;
            binDir = new File(basedir, "bin/internal");
        } else {
            binDir = new File(installerInfo.basedir, "bin");
        }
        boolean startNode = Boolean.parseBoolean(cmdLine.getOptionValue("start", "true"));
        String startupErrors = this.startNodeIfNecessary(binDir, startNode);
        if (startupErrors != null) {
            log.warn((Object)("The storage node reported the following errors while trying to start:\n\n" + startupErrors + "\n"));
            if (startupErrors.contains("Port already in use: " + installerInfo.jmxPort)) {
                log.warn((Object)"There is a conflict with the JMX port that prevented the storage node JVM from starting.");
                File confDir = new File(this.storageBasedir, "conf");
                File confFile = new File(confDir, "cassandra-jvm.properties");
                log.info((Object)("Change the jmx_port property in " + confFile + " to have the storage node listen " + "on a different port for JMX connections."));
                return 8;
            }
            if (startupErrors.contains("java.net.UnknownHostException")) {
                int from = startupErrors.indexOf("java.net.UnknownHostException:") + "java.net.UnknownHostException:".length();
                String hostname = startupErrors.substring(from, startupErrors.indexOf(58, from));
                log.error((Object)("Failed to resolve requested binding address. Please check the installation instructions and host DNS settings" + (this.isWindows() ? "." : " also make sure the hostname alias is set in /etc/hosts.") + " Unknown host: " + hostname));
                log.error((Object)"The storage installer will exit due to previous errors");
                return 11;
            }
            log.warn((Object)"Please review your configuration for possible sources of errors such as port conflicts or invalid arguments/options passed to the java executable.");
        }
        if (startNode) {
            boolean checkStatus = Boolean.parseBoolean(cmdLine.getOptionValue("check-status", "true"));
            if (checkStatus || this.isWindows()) {
                if (this.verifyNodeIsUp(installerInfo.hostname, installerInfo.jmxPort, 5, 3000L)) {
                    log.info((Object)"RHQ Storage Node is up and running and ready to service client requests");
                    log.info((Object)"Installation of the storage node has completed successfully.");
                    return 0;
                }
                log.warn((Object)"Could not verify that the node is up and running.");
                log.warn((Object)("Check the log file at " + installerInfo.logFile + " for errors."));
                log.warn((Object)"The storage installer will now exit");
                return 2;
            }
            if (this.isRunning()) {
                log.info((Object)"Installation of the storage node is complete. The node should be up and running");
                return 0;
            }
            log.warn((Object)("Installation of the storage node is complete, but the node does not appear to be running. No start up errors were reported.  Check the log file at " + installerInfo.logFile + " for any other possible errors."));
            return 1;
        }
        log.info((Object)"Installation of the storage node is complete");
        return 0;
    }

    private InstallerInfo install(org.apache.commons.cli.CommandLine cmdLine) throws StorageInstallerException {
        DeploymentOptionsFactory factory = new DeploymentOptionsFactory();
        DeploymentOptions deploymentOptions = factory.newDeploymentOptions();
        InstallerInfo installerInfo = new InstallerInfo();
        if (cmdLine.hasOption("dir")) {
            installerInfo.basedir = new File(cmdLine.getOptionValue("dir"));
            deploymentOptions.setBasedir(installerInfo.basedir.getAbsolutePath());
        } else {
            installerInfo.basedir = new File(this.serverBasedir, STORAGE_BASEDIR);
            deploymentOptions.setBasedir(installerInfo.basedir.getAbsolutePath());
        }
        try {
            if (cmdLine.hasOption("n")) {
                installerInfo.hostname = cmdLine.getOptionValue("n");
                InetAddress.getByName(installerInfo.hostname);
            } else {
                installerInfo.hostname = InetAddress.getLocalHost().getHostName();
            }
            if (InetAddress.getByName(installerInfo.hostname).isLoopbackAddress()) {
                log.warn((Object)("This Storage Node is bound to the loopback address " + installerInfo.hostname + " . " + "It will not be able to communicate with Storage Nodes on other machines," + " and it can only receive client requests from this machine."));
            }
            deploymentOptions.setListenAddress(installerInfo.hostname);
            deploymentOptions.setRpcAddress(installerInfo.hostname);
            String seeds = cmdLine.getOptionValue(StorageProperty.SEEDS.property(), installerInfo.hostname);
            deploymentOptions.setSeeds(seeds);
            String commitlogDir = cmdLine.getOptionValue(StorageProperty.COMMITLOG.property(), this.getDefaultCommitLogDir());
            String dataDir = cmdLine.getOptionValue(StorageProperty.DATA.property(), this.getDefaultDataDir());
            String savedCachesDir = cmdLine.getOptionValue(StorageProperty.SAVED_CACHES.property(), this.getDefaultSavedCachesDir());
            File commitLogDirFile = new File(commitlogDir);
            File dataDirFile = new File(dataDir);
            File savedCachesDirFile = new File(savedCachesDir);
            boolean verifyDataDirsEmpty = Boolean.valueOf(cmdLine.getOptionValue(StorageProperty.VERIFY_DATA_DIRS_EMPTY.property(), "true"));
            if (verifyDataDirsEmpty) {
                if (!this.isDirectoryEmpty(commitLogDirFile)) {
                    log.error((Object)("Commitlog directory is not empty. It should not exist for a new Storage Node [" + commitLogDirFile.getAbsolutePath() + "]"));
                    throw new StorageInstallerException("Installation cannot proceed. The commit log directory " + commitLogDirFile + " is not empty", 4);
                }
                if (!this.isDirectoryEmpty(dataDirFile)) {
                    log.error((Object)("Data directory is not empty. It should not exist for a new Storage Node [" + dataDirFile.getAbsolutePath() + "]"));
                    throw new StorageInstallerException("Installation cannot proceed. The data directory " + dataDirFile + " is not empty", 4);
                }
                if (!this.isDirectoryEmpty(savedCachesDirFile)) {
                    log.error((Object)("Saved caches directory is not empty. It should not exist for a new Storage Node [" + savedCachesDirFile.getAbsolutePath() + "]"));
                    throw new StorageInstallerException("Installation cannot proceed. The saved caches directory " + savedCachesDirFile + " is not empty", 4);
                }
            }
            this.verifyPortStatus(cmdLine, installerInfo);
            deploymentOptions.setCommitLogDir(commitlogDir);
            deploymentOptions.setDataDir(dataDirFile.getPath());
            deploymentOptions.setSavedCachesDir(savedCachesDir);
            deploymentOptions.setLogFileName(installerInfo.logFile);
            deploymentOptions.setLoggingLevel("INFO");
            deploymentOptions.setRpcPort(Integer.valueOf(9160));
            deploymentOptions.setCqlPort(Integer.valueOf(installerInfo.cqlPort));
            deploymentOptions.setGossipPort(Integer.valueOf(installerInfo.gossipPort));
            deploymentOptions.setJmxPort(Integer.valueOf(installerInfo.jmxPort));
            deploymentOptions.setHeapSize(cmdLine.getOptionValue(StorageProperty.HEAP_SIZE.property(), this.defaultHeapSize));
            deploymentOptions.setHeapNewSize(cmdLine.getOptionValue(StorageProperty.HEAP_NEW_SIZE.property(), this.defaultHeapNewSize));
            if (cmdLine.hasOption(StorageProperty.STACK_SIZE.property())) {
                deploymentOptions.setStackSize(cmdLine.getOptionValue(StorageProperty.STACK_SIZE.property()));
            }
            deploymentOptions.setNativeTransportMaxThreads(Integer.valueOf(128));
            deploymentOptions.load();
            ArrayList<String> errors = new ArrayList<String>();
            this.checkPerms(this.options.getOption(StorageProperty.SAVED_CACHES.property()), savedCachesDir, errors);
            this.checkPerms(this.options.getOption(StorageProperty.COMMITLOG.property()), commitlogDir, errors);
            this.checkPerms(this.options.getOption(StorageProperty.DATA.property()), dataDir, errors);
            if (!errors.isEmpty()) {
                log.error((Object)"Problems have been detected with one or more of the directories in which the storage node will need to store data");
                for (String error : errors) {
                    log.error((Object)error);
                }
                throw new StorageInstallerException("Installation cannot proceed. There are problems with one or more of the storage data directories.", 3);
            }
            Deployer deployer = this.getDeployer();
            deployer.setDeploymentOptions(deploymentOptions);
            this.storageBasedir.mkdirs();
            deployer.unzipDistro();
            deployer.applyConfigChanges();
            deployer.updateFilePerms();
            deployer.updateStorageAuthConf(this.asSet(installerInfo.hostname));
            return installerInfo;
        }
        catch (UnknownHostException unknownHostException) {
            throw new StorageInstallerException("Failed to resolve requested binding address. Please check the installation instructions and host DNS settings" + (this.isWindows() ? "." : " also make sure the hostname alias is set in /etc/hosts.") + " Unknown host " + unknownHostException.getMessage(), unknownHostException, 11);
        }
        catch (IOException e) {
            throw new StorageInstallerError("The upgrade cannot proceed. An unexpected I/O error occurred", e, 7);
        }
        catch (DeploymentException e) {
            throw new StorageInstallerException("The installation cannot proceed. An error occurred during storage node deployment.", e, 6);
        }
    }

    private void verifyPortStatus(org.apache.commons.cli.CommandLine cmdLine, InstallerInfo installerInfo) throws StorageInstallerException {
        installerInfo.jmxPort = this.getPort(cmdLine, StorageProperty.JMX_PORT.property(), this.defaultJmxPort);
        this.isPortBound(installerInfo.hostname, installerInfo.jmxPort, StorageProperty.JMX_PORT.property(), 8);
        installerInfo.cqlPort = this.getPort(cmdLine, StorageProperty.CQL_PORT.property(), this.defaultCqlPort);
        this.isPortBound(installerInfo.hostname, installerInfo.cqlPort, StorageProperty.CQL_PORT.property(), 9);
        installerInfo.gossipPort = this.getPort(cmdLine, StorageProperty.GOSSIP_PORT.property(), this.defaultGossipPort);
        this.isPortBound(installerInfo.hostname, installerInfo.gossipPort, StorageProperty.GOSSIP_PORT.property(), 10);
    }

    protected Deployer getDeployer() {
        return new Deployer();
    }

    private InstallerInfo upgrade(File upgradeFromDir) throws StorageInstallerException {
        DeploymentOptionsFactory factory = new DeploymentOptionsFactory();
        DeploymentOptions deploymentOptions = factory.newDeploymentOptions();
        InstallerInfo installerInfo = new InstallerInfo();
        if (!upgradeFromDir.isDirectory()) {
            log.error((Object)"The value passed to the upgrade option is not a directory. The value must be a valid path that points to the base directory of an existing RHQ server installation.");
            throw new StorageInstallerException("The upgrade cannot proceed. The value passed to the upgrade option is invalid.", 5);
        }
        File existingStorageDir = new File(upgradeFromDir, STORAGE_BASEDIR);
        if (!existingStorageDir.exists() || !existingStorageDir.isDirectory()) {
            log.error((Object)(existingStorageDir + " does not appear to be an existing RHQ storage node installation. " + "Check the value that was passed to the upgrade option and make sure it specifies the base " + "directory of an existing RHQ server installation."));
            throw new StorageInstallerException("The upgrade cannot proceed. " + existingStorageDir + " is not an " + "existing RHQ storage node installation", 5);
        }
        try {
            boolean isRHQ48Install;
            File oldConfDir = new File(existingStorageDir, "conf");
            File oldYamlFile = new File(oldConfDir, "cassandra.yaml");
            File newConfDir = new File(this.storageBasedir, "conf");
            File newYamlFile = new File(newConfDir, "cassandra.yaml");
            File cassandraEnvFile = new File(oldConfDir, "cassandra-env.sh");
            File cassandraJvmPropsFile = new File(newConfDir, "cassandra-jvm.properties");
            installerInfo.basedir = this.storageBasedir;
            if (cassandraEnvFile.exists()) {
                isRHQ48Install = true;
                installerInfo.jmxPort = this.parseJmxPortFromCassandrEnv(cassandraEnvFile);
            } else {
                isRHQ48Install = false;
                installerInfo.jmxPort = this.parseJmxPort(new File(oldConfDir, "cassandra-jvm.properties"));
            }
            deploymentOptions.setBasedir(this.storageBasedir.getAbsolutePath());
            deploymentOptions.setLogFileName(installerInfo.logFile);
            deploymentOptions.setLoggingLevel("INFO");
            deploymentOptions.setJmxPort(Integer.valueOf(installerInfo.jmxPort));
            deploymentOptions.setHeapSize(this.defaultHeapSize);
            deploymentOptions.setHeapNewSize(this.defaultHeapNewSize);
            deploymentOptions.load();
            Deployer deployer = new Deployer();
            deployer.setDeploymentOptions(deploymentOptions);
            this.storageBasedir.mkdirs();
            deployer.unzipDistro();
            deployer.applyConfigChanges();
            deployer.updateFilePerms();
            ConfigEditor oldYamlEditor = new ConfigEditor(oldYamlFile);
            oldYamlEditor.load();
            ConfigEditor newYamlEditor = new ConfigEditor(newYamlFile);
            newYamlEditor.load();
            installerInfo.hostname = oldYamlEditor.getListenAddress();
            newYamlEditor.setListenAddress(installerInfo.hostname);
            newYamlEditor.setRpcAddress(installerInfo.hostname);
            installerInfo.cqlPort = oldYamlEditor.getNativeTransportPort();
            newYamlEditor.setNativeTransportPort(Integer.valueOf(installerInfo.cqlPort));
            installerInfo.gossipPort = oldYamlEditor.getStoragePort();
            newYamlEditor.setStoragePort(Integer.valueOf(installerInfo.gossipPort));
            newYamlEditor.setCommitLogDirectory(oldYamlEditor.getCommitLogDirectory());
            newYamlEditor.setSavedCachesDirectory(oldYamlEditor.getSavedCachesDirectory());
            newYamlEditor.setDataFileDirectories(oldYamlEditor.getDataFileDirectories());
            newYamlEditor.setSeeds(new String[]{installerInfo.hostname});
            newYamlEditor.save();
            if (isRHQ48Install) {
                Properties jvmProps = new Properties();
                jvmProps.load(new FileInputStream(cassandraJvmPropsFile));
                PropertiesFileUpdate propertiesUpdater = new PropertiesFileUpdate(cassandraJvmPropsFile.getAbsolutePath());
                jvmProps.setProperty("jmx_port", Integer.toString(installerInfo.jmxPort));
                propertiesUpdater.update(jvmProps);
                deployer.updateStorageAuthConf(this.asSet(installerInfo.hostname));
            } else {
                File oldStorageAuthConfFile = new File(oldConfDir, "rhq-storage-auth.conf");
                File newStorageAuthConfFile = new File(newConfDir, "rhq-storage-auth.conf");
                StreamUtil.copy((InputStream)new FileInputStream(oldStorageAuthConfFile), (OutputStream)new FileOutputStream(newStorageAuthConfFile));
            }
            return installerInfo;
        }
        catch (UnknownHostException unknownHostException) {
            throw new StorageInstallerException("Failed to resolve requested binding address. Please check the installation instructions and host DNS settings" + (this.isWindows() ? "." : " also make sure the hostname alias is set in /etc/hosts.") + " Unknown host " + unknownHostException.getMessage(), unknownHostException, 11);
        }
        catch (IOException e) {
            throw new StorageInstallerError("The upgrade cannot proceed. An unexpected I/O error occurred", e, 7);
        }
        catch (DeploymentException e) {
            throw new StorageInstallerException("THe upgrade cannot proceed. An error occurred during the storage node deployment", e, 6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undo(File fromDir, boolean noStamp) {
        if (noStamp) {
            return;
        }
        try {
            log.info((Object)"Undoing storage node version stamp...");
            if (!fromDir.isDirectory()) {
                log.error((Object)"The value passed to the upgrade option is not a directory. The value must be a valid path that points to the base directory of an existing RHQ server installation.");
                throw new StorageInstallerException("The upgrade cannot proceed. The value passed to the upgrade option is invalid.", 5);
            }
            File existingStorageDir = new File(fromDir, STORAGE_BASEDIR);
            if (!existingStorageDir.exists() || !existingStorageDir.isDirectory()) {
                log.error((Object)(existingStorageDir + " does not appear to be an existing RHQ storage node installation. " + "Check the value that was passed to the upgrade option and make sure it specifies the base " + "directory of an existing RHQ server installation."));
                throw new StorageInstallerException("The upgrade cannot proceed. " + existingStorageDir + " is not an " + "existing RHQ storage node installation", 5);
            }
            File oldConfDir = new File(existingStorageDir, "conf");
            File oldYamlFile = new File(oldConfDir, "cassandra.yaml");
            ConfigEditor oldYamlEditor = new ConfigEditor(oldYamlFile);
            oldYamlEditor.load();
            String storageNodeAddress = oldYamlEditor.getListenAddress();
            File oldServerPropsFile = new File(fromDir, "bin/rhq-server.properties");
            Properties dbProperties = new Properties();
            FileInputStream oldServerPropsFileInputStream = new FileInputStream(oldServerPropsFile);
            try {
                dbProperties.load(oldServerPropsFileInputStream);
            }
            finally {
                oldServerPropsFileInputStream.close();
            }
            String version = "PRE-" + StorageInstaller.class.getPackage().getImplementationVersion();
            StorageInstaller.stampStorageNodeVersion(dbProperties, storageNodeAddress, version);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to undo version stamp (DB Restore recommended unless original problem was applying the version stamp): " + e.getMessage()));
        }
    }

    private boolean isDirectoryEmpty(File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            return files == null || files.length == 0;
        }
        return true;
    }

    private Set<String> asSet(String string) {
        TreeSet<String> set = new TreeSet<String>();
        set.add(string);
        return set;
    }

    private int getPort(org.apache.commons.cli.CommandLine cmdLine, String option, int defaultValue) {
        return Integer.parseInt(cmdLine.getOptionValue(option, Integer.toString(defaultValue)));
    }

    private void checkPerms(Option option, String path, List<String> errors) {
        try {
            log.info((Object)("Checking perms for " + path));
            File dir = new File(path);
            if (!dir.isAbsolute()) {
                dir = new File(new File(this.storageBasedir, "bin"), path);
            }
            if ((dir = dir.getCanonicalFile()).exists()) {
                if (dir.isFile()) {
                    errors.add(path + " is not a directory. Use the --" + option.getLongOpt() + " to change this value.");
                }
            } else {
                File parentDir = dir.getParentFile();
                while (!parentDir.exists()) {
                    parentDir = parentDir.getParentFile();
                }
                if (!parentDir.canWrite()) {
                    errors.add("The user running this installer does not appear to have write permissions to " + parentDir + ". Either make sure that the user running the storage node has write permissions or use the --" + option.getLongOpt() + " to change this value.");
                }
            }
        }
        catch (Exception e) {
            errors.add("The request path cannot be constructed (path: " + path + "). " + "Please use a valid and also make sure the user running the storage node has write permissions for the path.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void isPortBound(String address, int port, String portName, int potentialErrorCode) throws StorageInstallerException {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket();
            serverSocket.bind(new InetSocketAddress(address, port));
        }
        catch (BindException e) {
            throw new StorageInstallerException("The " + portName + " (" + address + ":" + port + ") is already in use. " + "Installation cannot proceed.", potentialErrorCode);
        }
        catch (IOException e) {
            log.warn((Object)("An unexpected error occurred while checking the " + portName + " port"), (Throwable)e);
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    log.error((Object)("An error occurred trying to close the connection to the " + portName), (Throwable)e);
                }
            }
        }
    }

    private PropertiesFileUpdate getServerProperties() {
        String sysprop = System.getProperty("rhq.server.properties-file");
        if (sysprop == null) {
            throw new RuntimeException("The required system property [rhq.server.properties-file] is not defined.");
        }
        File file = new File(sysprop);
        if (!file.exists() || !file.isFile()) {
            throw new RuntimeException("System property [" + sysprop + "] points to an invalid file.");
        }
        return new PropertiesFileUpdate(file.getAbsolutePath());
    }

    private String startNodeIfNecessary(File binDir, boolean startNode) throws Exception {
        if (this.isWindows()) {
            CommandLine cmdLine = new CommandLine("cmd.exe");
            cmdLine.addArgument("/C");
            cmdLine.addArgument("rhq-storage.bat");
            cmdLine.addArgument("stop");
            String errOutput = this.exec(binDir, cmdLine);
            if (!errOutput.isEmpty()) {
                return errOutput;
            }
            cmdLine = new CommandLine("cmd.exe");
            cmdLine.addArgument("/C");
            cmdLine.addArgument("rhq-storage.bat");
            cmdLine.addArgument("remove");
            errOutput = this.exec(binDir, cmdLine);
            if (!errOutput.isEmpty()) {
                return errOutput;
            }
            cmdLine = new CommandLine("cmd.exe");
            cmdLine.addArgument("/C");
            cmdLine.addArgument("rhq-storage.bat");
            cmdLine.addArgument("install");
            errOutput = this.exec(binDir, cmdLine);
            if (!errOutput.isEmpty()) {
                return errOutput;
            }
            if (startNode) {
                log.info((Object)"Starting RHQ Storage Node");
                cmdLine = new CommandLine("cmd.exe");
                cmdLine.addArgument("/C");
                cmdLine.addArgument("rhq-storage.bat");
                cmdLine.addArgument("start");
                errOutput = this.exec(binDir, cmdLine);
                if (!errOutput.isEmpty()) {
                    return errOutput;
                }
            }
        } else if (startNode) {
            log.info((Object)"Starting RHQ Storage Node");
            CommandLine cmdLine = new CommandLine("./cassandra");
            cmdLine.addArgument("-p");
            cmdLine.addArgument(new File(binDir, "cassandra.pid").getAbsolutePath());
            String errOutput = this.exec(binDir, cmdLine);
            if (!errOutput.isEmpty()) {
                return errOutput;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String exec(File workingDir, CommandLine cmdLine) throws Exception {
        DefaultExecutor executor = new DefaultExecutor();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        NullOutputStream nullOs = new NullOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)nullOs, (OutputStream)buffer);
        executor.setWorkingDirectory(workingDir);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        String result = "";
        try {
            this.exec((Executor)executor, cmdLine);
            result = buffer.toString();
        }
        finally {
            try {
                buffer.close();
                nullOs.close();
            }
            catch (Exception e) {}
        }
        return result;
    }

    protected void exec(Executor executor, CommandLine cmdLine) throws IOException {
        executor.execute(cmdLine);
    }

    private boolean isWindows() {
        String operatingSystem = System.getProperty("os.name").toLowerCase(Locale.US);
        return operatingSystem.contains("windows");
    }

    private boolean isRunning() {
        File binDir = new File(this.storageBasedir, "bin");
        return new File(binDir, "cassandra.pid").exists();
    }

    boolean verifyNodeIsUp(String address, int jmxPort, int retries, long timeout) throws Exception {
        String url = "service:jmx:rmi:///jndi/rmi://" + address + ":" + jmxPort + "/jmxrmi";
        JMXServiceURL serviceURL = new JMXServiceURL(url);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        HashMap env = new HashMap();
        for (int i = 0; i < retries; ++i) {
            try {
                JMXConnector connector = JMXConnectorFactory.connect(serviceURL, env);
                MBeanServerConnection serverConnection = connector.getMBeanServerConnection();
                ObjectName storageService = new ObjectName("org.apache.cassandra.db:type=StorageService");
                Boolean nativeTransportRunning = (Boolean)serverConnection.getAttribute(storageService, "NativeTransportRunning");
                return nativeTransportRunning;
            }
            catch (Exception e) {
                if (i < retries) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"The storage node is not up.", (Throwable)e);
                    } else {
                        Throwable rootCause = ThrowableUtil.getRootCause((Throwable)e);
                        log.info((Object)("The storage node is not up: " + rootCause.getClass().getName() + ": " + rootCause.getMessage()));
                    }
                    log.info((Object)("Checking storage node status again in " + timeout * (long)(i + 1) + " ms..."));
                }
                Thread.sleep(timeout * (long)(i + 1));
                continue;
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private int parseJmxPortFromCassandrEnv(File cassandraEnvFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[WHILELOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int parseJmxPort(File cassandraJvmOptsFile) {
        if (this.isWindows()) {
            return this.defaultJmxPort;
        }
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(cassandraJvmOptsFile));
            String jmxPort = properties.getProperty("jmx_port");
            if (StringUtil.isEmpty((String)jmxPort)) {
                log.error((Object)"The property [jmx_port] is undefined.");
                throw new RuntimeException("Cannot determine JMX port");
            }
            jmxPort = jmxPort.replaceAll("\"", "");
            return Integer.parseInt(jmxPort);
        }
        catch (IOException e) {
            log.error((Object)"Failed to parse JMX port. There was an unexpected IO error", (Throwable)e);
            throw new RuntimeException("Failed to parse JMX port due to IO error: " + e.getMessage());
        }
    }

    private String getDefaultCommitLogDir() {
        return DEFAULT_COMMIT_LOG_DIR;
    }

    private String getDefaultDataDir() {
        return DEFAULT_DATA_DIR;
    }

    private String getDefaultSavedCachesDir() {
        return DEFAULT_SAVED_CACHES_DIR;
    }

    private static void stampStorageNodeVersion(Properties dbProperties, String storageNodeAddress, String version) throws Exception {
        String dbUrl = dbProperties.getProperty("rhq.server.database.connection-url");
        String dbUsername = dbProperties.getProperty("rhq.server.database.user-name");
        String obfuscatedDbPassword = dbProperties.getProperty("rhq.server.database.password");
        String clearTextDbPassword = PicketBoxObfuscator.decode((String)obfuscatedDbPassword);
        StorageInstaller.updateStorageNodeVersion(dbUrl, dbUsername, clearTextDbPassword, storageNodeAddress, version);
    }

    private static void updateStorageNodeVersion(String connectionUrl, String username, String password, String storageNodeAddress, String version) throws Exception {
        Connection connection = null;
        try {
            connection = DbUtil.getConnection((String)connectionUrl, (String)username, (String)password);
            StorageNodeVersionColumnUpgrader versionColumnUpgrader = new StorageNodeVersionColumnUpgrader();
            versionColumnUpgrader.upgrade(connection, version);
            int rowsUpdated = versionColumnUpgrader.setVersionForNodeWithAddress(connection, version, storageNodeAddress);
            if (1 != rowsUpdated) {
                throw new IllegalStateException("Expected [1] StorageNode update but updated [" + rowsUpdated + "].");
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Unable to update Storage Node [" + storageNodeAddress + "] to version [" + version + "].  Make sure the rhq-server.properties file has the correct database property settings! Cause: " + e.getMessage());
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(connection);
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Connection)connection);
    }

    public void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        String syntax = "rhq-storage-installer.sh|bat [options]";
        String header = "";
        helpFormatter.printHelp(syntax, header, this.getHelpOptions(), null);
    }

    public Options getHelpOptions() {
        Options helpOptions = new Options();
        for (Option option : this.options.getOptions()) {
            if (option.getLongOpt().equals((Object)StorageProperty.VERIFY_DATA_DIRS_EMPTY)) continue;
            helpOptions.addOption(option);
        }
        return helpOptions;
    }

    public Options getOptions() {
        return this.options;
    }

    public static void main(String[] args) throws Exception {
        StorageInstaller installer = new StorageInstaller();
        log.info((Object)"Running RHQ Storage Node installer...");
        try {
            PosixParser parser = new PosixParser();
            org.apache.commons.cli.CommandLine cmdLine = parser.parse(installer.getOptions(), args);
            int status = installer.run(cmdLine);
            System.exit(status);
        }
        catch (ParseException parseException) {
            installer.printUsage();
            System.exit(100);
        }
    }

    private static class InstallerInfo {
        File basedir;
        String logFile = "../../logs/rhq-storage.log";
        int jmxPort;
        int cqlPort;
        int gossipPort;
        String hostname;

        private InstallerInfo() {
        }
    }
}

