/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport;

import java.util.Map;
import java.util.Properties;
import javax.xml.ws.BindingProvider;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.v3.client.JUDDIApiService;
import org.apache.juddi.v3.client.UDDIService;
import org.apache.juddi.v3.client.config.UDDIClerkManager;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.client.transport.TransportException;
import org.apache.juddi.v3_service.JUDDIApiPortType;
import org.uddi.v3_service.UDDICustodyTransferPortType;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class JAXWSTransport
extends Transport {
    String nodeName = null;
    String managerName = null;
    UDDIInquiryPortType inquiryService = null;
    UDDISecurityPortType securityService = null;
    UDDIPublicationPortType publishService = null;
    UDDISubscriptionPortType subscriptionService = null;
    UDDISubscriptionListenerPortType subscriptionListenerService = null;
    UDDICustodyTransferPortType custodyTransferService = null;
    JUDDIApiPortType publisherService = null;

    public JAXWSTransport() {
        this.nodeName = "default";
    }

    public JAXWSTransport(String nodeName) {
        this.nodeName = nodeName;
    }

    public JAXWSTransport(String managerName, String nodeName) {
        this.managerName = managerName;
        this.nodeName = nodeName;
    }

    @Override
    public UDDIInquiryPortType getUDDIInquiryService(String endpointURL) throws TransportException {
        if (this.inquiryService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getInquiryUrl();
                }
                UDDIService service = new UDDIService();
                this.inquiryService = service.getUDDIInquiryPort();
                Map requestContext = ((BindingProvider)this.inquiryService).getRequestContext();
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
                this.setCredentials(requestContext);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.inquiryService;
    }

    @Override
    public UDDISecurityPortType getUDDISecurityService(String endpointURL) throws TransportException {
        if (this.securityService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getSecurityUrl();
                }
                UDDIService service = new UDDIService();
                this.securityService = service.getUDDISecurityPort();
                Map requestContext = ((BindingProvider)this.securityService).getRequestContext();
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
                this.setCredentials(requestContext);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.securityService;
    }

    @Override
    public UDDIPublicationPortType getUDDIPublishService(String endpointURL) throws TransportException {
        if (this.publishService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getPublishUrl();
                }
                UDDIService service = new UDDIService();
                this.publishService = service.getUDDIPublicationPort();
                Map requestContext = ((BindingProvider)this.publishService).getRequestContext();
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
                this.setCredentials(requestContext);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.publishService;
    }

    @Override
    public UDDISubscriptionPortType getUDDISubscriptionService(String endpointURL) throws TransportException {
        if (this.subscriptionService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getSubscriptionUrl();
                }
                UDDIService service = new UDDIService();
                this.subscriptionService = service.getUDDISubscriptionPort();
                Map requestContext = ((BindingProvider)this.subscriptionService).getRequestContext();
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
                this.setCredentials(requestContext);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.subscriptionService;
    }

    @Override
    public UDDISubscriptionListenerPortType getUDDISubscriptionListenerService(String endpointURL) throws TransportException {
        if (this.subscriptionListenerService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getSubscriptionListenerUrl();
                }
                UDDIService service = new UDDIService();
                this.subscriptionListenerService = service.getUDDISubscriptionListenerPort();
                Map requestContext = ((BindingProvider)this.subscriptionListenerService).getRequestContext();
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
                this.setCredentials(requestContext);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.subscriptionListenerService;
    }

    @Override
    public UDDICustodyTransferPortType getUDDICustodyTransferService(String endpointURL) throws TransportException {
        if (this.custodyTransferService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getCustodyTransferUrl();
                }
                UDDIService service = new UDDIService();
                this.custodyTransferService = service.getUDDICustodyPort();
                Map requestContext = ((BindingProvider)this.custodyTransferService).getRequestContext();
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
                this.setCredentials(requestContext);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.custodyTransferService;
    }

    @Override
    public JUDDIApiPortType getJUDDIApiService(String endpointURL) throws TransportException {
        if (this.publisherService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getJuddiApiUrl();
                }
                JUDDIApiService service = new JUDDIApiService();
                this.publisherService = (JUDDIApiPortType)service.getPort(JUDDIApiPortType.class);
                Map requestContext = ((BindingProvider)this.publisherService).getRequestContext();
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
                this.setCredentials(requestContext);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.publisherService;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    private void setCredentials(Map<String, Object> requestContext) throws ConfigurationException {
        UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
        Properties properties = manager.getClientConfig().getUDDINode(this.nodeName).getProperties();
        if (properties != null) {
            String username = null;
            String password = null;
            if (properties.containsKey("basicAuthUsername")) {
                username = properties.getProperty("basicAuthUsername");
            }
            if (properties.containsKey("basicAuthPassword")) {
                password = properties.getProperty("basicAuthPassword");
            }
            if (username != null && password != null) {
                requestContext.put("javax.xml.ws.security.auth.username", username);
                requestContext.put("javax.xml.ws.security.auth.password", password);
            }
        }
    }
}

