/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.web;

import com.redhat.gss.redhat_support_lib.errors.FTPException;
import com.redhat.gss.redhat_support_lib.helpers.ConfigHelper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;

public class ConnectionManager {
    ConfigHelper config = null;
    public static TrustManager[] gullibleManagers = new TrustManager[]{new X509TrustManager(){

        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};
    public static HostnameVerifier gullibleVerifier = new HostnameVerifier(){

        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public ConnectionManager(ConfigHelper config) {
        this.config = config;
    }

    public Client getConnection() throws MalformedURLException {
        DefaultApacheHttpClient4Config clientConfig = new DefaultApacheHttpClient4Config();
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager();
        clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.connectionManager", connectionManager);
        if (this.config.getProxyUrl() != null) {
            clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", this.config.getProxyUrl() + ":" + this.config.getProxyPort());
            if (this.config.getProxyUser() != null && this.config.getProxyPassword() != null) {
                clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyUsername", this.config.getProxyUser());
                clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyPassword", this.config.getProxyPassword());
            }
        }
        clientConfig.getClasses().add(MultiPartWriter.class);
        if (this.config.isDevel()) {
            try {
                connectionManager.getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(ConnectionManager.createGullibleSslContext(), SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER)));
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        ApacheHttpClient4 client = ApacheHttpClient4.create((ClientConfig)clientConfig);
        client.setConnectTimeout(Integer.valueOf(this.config.getTimeout()));
        client.setReadTimeout(Integer.valueOf(this.config.getTimeout()));
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.config.getUsername(), this.config.getPassword()));
        client.addFilter(new ClientFilter(){

            public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
                request.getHeaders().add((Object)"User-Agent", (Object)ConnectionManager.this.config.getUserAgent());
                return this.getNext().handle(request);
            }
        });
        return client;
    }

    public ConfigHelper getConfig() {
        return this.config;
    }

    public static SSLContext createGullibleSslContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("SSL");
        ctx.init(null, gullibleManagers, new SecureRandom());
        return ctx;
    }

    public FTPClient getFTP() throws IOException, FTPException {
        Object ftp = null;
        ftp = this.config.getProxyUrl() == null ? new FTPClient() : new FTPHTTPClient(this.config.getProxyUrl().getHost(), this.config.getProxyPort(), this.config.getProxyUser(), this.config.getProxyPassword());
        ftp.connect(this.config.getFtpHost(), this.config.getFtpPort());
        if (!ftp.login(this.config.getFtpUsername(), this.config.getFtpPassword())) {
            throw new FTPException("Error during FTP login");
        }
        return ftp;
    }
}

