/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.api.API;
import com.redhat.gss.redhat_support_lib.errors.RequestException;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.Boundary;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import javax.ws.rs.core.MediaType;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseQuery {
    private static final Logger LOGGER = Logger.getLogger((String)API.class.getName());

    protected <T> T get(WebResource webResource, Class<T> c) throws RequestException {
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/xml"}).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            LOGGER.debug((Object)("Failed : HTTP error code : " + response.getClientResponseStatus().getStatusCode() + " - " + response.getClientResponseStatus().getReasonPhrase()));
            throw new RequestException(String.valueOf(response.getClientResponseStatus().getStatusCode()) + " - " + response.getClientResponseStatus().getReasonPhrase());
        }
        return (T)response.getEntity(c);
    }

    protected ClientResponse add(WebResource webResource, Object object) throws RequestException {
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/xml"}).post(ClientResponse.class, object);
        if (response.getStatus() > 399) {
            LOGGER.debug((Object)("Failed : HTTP error code : " + response.getClientResponseStatus().getStatusCode() + " - " + response.getClientResponseStatus().getReasonPhrase()));
            throw new RequestException(String.valueOf(response.getClientResponseStatus().getStatusCode()) + " - " + response.getClientResponseStatus().getReasonPhrase());
        }
        return response;
    }

    protected <T> T add(WebResource webResource, Object object, Class<T> c) throws RequestException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.type("application/xml").accept(new String[]{"application/xml"})).post(ClientResponse.class, object);
        if (response.getStatus() > 399) {
            LOGGER.debug((Object)("Failed : HTTP error code : " + response.getClientResponseStatus().getStatusCode() + " - " + response.getClientResponseStatus().getReasonPhrase()));
            throw new RequestException(String.valueOf(response.getClientResponseStatus().getStatusCode()) + " - " + response.getClientResponseStatus().getReasonPhrase());
        }
        return (T)response.getEntity(c);
    }

    protected ClientResponse update(WebResource webResource, Object object) throws RequestException {
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/xml"}).put(ClientResponse.class, object);
        if (response.getStatus() > 399) {
            LOGGER.debug((Object)("Failed : HTTP error code : " + response.getClientResponseStatus().getStatusCode() + " - " + response.getClientResponseStatus().getReasonPhrase()));
            throw new RequestException(String.valueOf(response.getClientResponseStatus().getStatusCode()) + " - " + response.getClientResponseStatus().getReasonPhrase());
        }
        return response;
    }

    protected boolean delete(WebResource webResource) throws RequestException {
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/xml"}).delete(ClientResponse.class);
        if (response.getStatus() > 399) {
            LOGGER.debug((Object)("Failed : HTTP error code : " + response.getClientResponseStatus().getStatusCode() + " - " + response.getClientResponseStatus().getReasonPhrase()));
            throw new RequestException(String.valueOf(response.getClientResponseStatus().getStatusCode()) + " - " + response.getClientResponseStatus().getReasonPhrase());
        }
        return true;
    }

    protected ClientResponse upload(WebResource webResource, File file, String description) throws UniformInterfaceException, ClientHandlerException, FileNotFoundException, ParseException, RequestException {
        FormDataMultiPart part = new FormDataMultiPart();
        if (description != null) {
            part.bodyPart((BodyPart)new FormDataBodyPart("description", description));
        }
        part.bodyPart((BodyPart)new FileDataBodyPart("file", file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.accept(new String[]{"application/xml"}).type(Boundary.addBoundary((MediaType)MediaType.MULTIPART_FORM_DATA_TYPE))).header("description", (Object)description)).post(ClientResponse.class, (Object)part);
        if (response.getStatus() > 399) {
            LOGGER.debug((Object)("Failed : HTTP error code : " + response.getClientResponseStatus().getStatusCode() + " - " + response.getClientResponseStatus().getReasonPhrase()));
            throw new RequestException(String.valueOf(response.getClientResponseStatus().getStatusCode()) + " - " + response.getClientResponseStatus().getReasonPhrase());
        }
        return response;
    }
}

