/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.errors.FTPException;
import com.redhat.gss.redhat_support_lib.errors.RequestException;
import com.redhat.gss.redhat_support_lib.helpers.FilterHelper;
import com.redhat.gss.redhat_support_lib.helpers.QueryBuilder;
import com.redhat.gss.redhat_support_lib.infrastructure.BaseQuery;
import com.redhat.gss.redhat_support_lib.infrastructure.Comments;
import com.redhat.gss.redhat_support_lib.parsers.Attachment;
import com.redhat.gss.redhat_support_lib.parsers.Comment;
import com.redhat.gss.redhat_support_lib.web.ConnectionManager;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.FileUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attachments
extends BaseQuery {
    private static final Logger LOGGER = Logger.getLogger((String)Attachments.class.getName());
    ConnectionManager connectionManager = null;

    public Attachments(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public List<Attachment> list(String caseNumber, String startDate, String endDate, String[] kwargs) throws RequestException, MalformedURLException {
        String url = "/rs/cases/{caseNumber}/attachments";
        url = url.replace("{caseNumber}", caseNumber);
        ArrayList<String> queryParams = new ArrayList<String>();
        if (startDate != null) {
            queryParams.add("startDate=" + startDate);
        }
        if (endDate != null) {
            queryParams.add("endDate=" + endDate);
        }
        WebResource webResource = this.connectionManager.getConnection().resource(QueryBuilder.appendQuery(String.valueOf(this.connectionManager.getConfig().getUrl()) + url, queryParams));
        com.redhat.gss.redhat_support_lib.parsers.Attachments attachments = this.get(webResource, com.redhat.gss.redhat_support_lib.parsers.Attachments.class);
        return FilterHelper.filterResults(attachments.getAttachment(), kwargs);
    }

    public String get(String caseNumber, String attachmentUUID, String fileName, String destDir) throws Exception {
        String url = "/rs/cases/{caseNumber}/attachments/{attachmentUUID}";
        url = url.replace("{caseNumber}", caseNumber);
        url = url.replace("{attachmentUUID}", attachmentUUID);
        WebResource webResource = this.connectionManager.getConnection().resource(String.valueOf(this.connectionManager.getConfig().getUrl()) + url);
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/xml"}).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            LOGGER.debug((Object)("Failed : HTTP error code : " + response.getStatus()));
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        File tempfile = (File)response.getEntity(File.class);
        String filePath = new String();
        if (destDir != null && !(filePath = filePath.concat(destDir)).endsWith(File.separator)) {
            filePath = filePath.concat(File.separator);
        }
        if (fileName != null) {
            filePath = filePath.concat(fileName);
        } else {
            String name = (String)response.getHeaders().getFirst((Object)"Content-Disposition");
            String[] temp = name.split("\"");
            String decoded = MimeUtility.decodeWord((String)temp[1]);
            filePath = filePath.concat(decoded);
        }
        File file = new File(filePath);
        FileUtils.moveFile((File)tempfile, (File)file);
        return file.getName();
    }

    public boolean delete(String caseNumber, String attachmentUUID) throws RequestException, MalformedURLException {
        String url = "/rs/cases/{caseNumber}/attachments/{attachmentUUID}";
        url = url.replace("{caseNumber}", caseNumber);
        url = url.replace("{attachmentUUID}", attachmentUUID);
        WebResource webResource = this.connectionManager.getConnection().resource(String.valueOf(this.connectionManager.getConfig().getUrl()) + url);
        return this.delete(webResource);
    }

    public String add(String caseNumber, boolean publicVis, String fileName, String description) throws Exception {
        String url = "/rs/cases/{caseNumber}/attachments";
        url = url.replace("{caseNumber}", caseNumber);
        File file = new File(fileName);
        ArrayList<String> queryParams = new ArrayList<String>();
        queryParams.add("public=" + Boolean.toString(publicVis));
        String uri = null;
        if (file.length() > this.connectionManager.getConfig().getFtpFileSize()) {
            FTPClient ftp = null;
            try {
                ftp = this.connectionManager.getFTP();
                ftp.cwd(this.connectionManager.getConfig().getFtpDir());
                ftp.enterLocalPassiveMode();
                if (!ftp.storeFile(file.getName(), (InputStream)new FileInputStream(file))) {
                    throw new FTPException("Error during FTP store file.");
                }
            }
            finally {
                ftp.logout();
            }
            String cmntText = "The file " + fileName + " exceeds the byte limit to attach a file to a case; therefore, the file was uploaded to " + this.connectionManager.getConfig().getFtpHost() + "as " + file.getName();
            Comment comment = new Comment();
            comment.setCaseNumber(caseNumber);
            comment.setPublic(true);
            comment.setText(cmntText);
            Comments comments = new Comments(this.connectionManager);
            comments.add(comment);
        } else {
            WebResource webResource = this.connectionManager.getConnection().resource(QueryBuilder.appendQuery(String.valueOf(this.connectionManager.getConfig().getUrl()) + url, queryParams));
            uri = (String)this.upload(webResource, file, description).getHeaders().getFirst((Object)"location");
        }
        return uri;
    }
}

