/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.api;

import com.redhat.gss.redhat_support_lib.helpers.ConfigHelper;
import com.redhat.gss.redhat_support_lib.infrastructure.Articles;
import com.redhat.gss.redhat_support_lib.infrastructure.Attachments;
import com.redhat.gss.redhat_support_lib.infrastructure.Cases;
import com.redhat.gss.redhat_support_lib.infrastructure.Comments;
import com.redhat.gss.redhat_support_lib.infrastructure.Entitlements;
import com.redhat.gss.redhat_support_lib.infrastructure.Groups;
import com.redhat.gss.redhat_support_lib.infrastructure.Ping;
import com.redhat.gss.redhat_support_lib.infrastructure.Problems;
import com.redhat.gss.redhat_support_lib.infrastructure.Products;
import com.redhat.gss.redhat_support_lib.infrastructure.Solutions;
import com.redhat.gss.redhat_support_lib.infrastructure.Symptoms;
import com.redhat.gss.redhat_support_lib.web.ConnectionManager;
import java.io.IOException;
import java.net.URL;

public class API {
    ConfigHelper config = null;
    ConnectionManager connectionManager = null;
    Solutions solutions = null;
    Articles articles = null;
    Cases cases = null;
    Products products = null;
    Comments comments = null;
    Entitlements entitlements = null;
    Problems problems = null;
    Attachments attachments = null;
    Ping ping = null;
    Groups groups = null;
    Symptoms symptoms = null;

    public API(String username, String password, String url, String proxyUser, String proxyPassword, URL proxyUrl, int proxyPort, String userAgent) {
        this.config = new ConfigHelper(username, password, url, proxyUser, proxyPassword, proxyUrl, proxyPort, userAgent, false);
        this.connectionManager = new ConnectionManager(this.config);
        this.solutions = new Solutions(this.connectionManager);
        this.articles = new Articles(this.connectionManager);
        this.cases = new Cases(this.connectionManager);
        this.products = new Products(this.connectionManager);
        this.comments = new Comments(this.connectionManager);
        this.entitlements = new Entitlements(this.connectionManager);
        this.problems = new Problems(this.connectionManager);
        this.attachments = new Attachments(this.connectionManager);
        this.ping = new Ping(this.connectionManager);
        this.groups = new Groups(this.connectionManager);
        this.symptoms = new Symptoms(this.connectionManager);
    }

    public API(String username, String password, String url, String proxyUser, String proxyPassword, URL proxyUrl, int proxyPort, String userAgent, boolean isDevel) {
        this.config = new ConfigHelper(username, password, url, proxyUser, proxyPassword, proxyUrl, proxyPort, userAgent, isDevel);
        this.connectionManager = new ConnectionManager(this.config);
        this.solutions = new Solutions(this.connectionManager);
        this.articles = new Articles(this.connectionManager);
        this.cases = new Cases(this.connectionManager);
        this.products = new Products(this.connectionManager);
        this.comments = new Comments(this.connectionManager);
        this.entitlements = new Entitlements(this.connectionManager);
        this.problems = new Problems(this.connectionManager);
        this.attachments = new Attachments(this.connectionManager);
        this.ping = new Ping(this.connectionManager);
        this.groups = new Groups(this.connectionManager);
        this.symptoms = new Symptoms(this.connectionManager);
    }

    public API(String username, String password, String url, String proxyUsername, String proxyPassword, URL hostUrl, int proxyPort, String ftpHost, int ftpPort, String ftpUsername, String ftpPassword, boolean devel) {
        this.config = new ConfigHelper(username, password, url, proxyUsername, proxyPassword, hostUrl, proxyPort, ftpHost, ftpPort, ftpUsername, ftpPassword, devel);
        this.connectionManager = new ConnectionManager(this.config);
        this.solutions = new Solutions(this.connectionManager);
        this.articles = new Articles(this.connectionManager);
        this.cases = new Cases(this.connectionManager);
        this.products = new Products(this.connectionManager);
        this.comments = new Comments(this.connectionManager);
        this.entitlements = new Entitlements(this.connectionManager);
        this.problems = new Problems(this.connectionManager);
        this.attachments = new Attachments(this.connectionManager);
        this.ping = new Ping(this.connectionManager);
        this.groups = new Groups(this.connectionManager);
        this.symptoms = new Symptoms(this.connectionManager);
    }

    public API(String configFileName) throws IOException {
        this.config = new ConfigHelper(configFileName);
        this.connectionManager = new ConnectionManager(this.config);
        this.solutions = new Solutions(this.connectionManager);
        this.articles = new Articles(this.connectionManager);
        this.cases = new Cases(this.connectionManager);
        this.products = new Products(this.connectionManager);
        this.comments = new Comments(this.connectionManager);
        this.entitlements = new Entitlements(this.connectionManager);
        this.problems = new Problems(this.connectionManager);
        this.attachments = new Attachments(this.connectionManager);
        this.ping = new Ping(this.connectionManager);
        this.groups = new Groups(this.connectionManager);
        this.symptoms = new Symptoms(this.connectionManager);
    }

    public Solutions getSolutions() {
        return this.solutions;
    }

    public Articles getArticles() {
        return this.articles;
    }

    public Cases getCases() {
        return this.cases;
    }

    public Products getProducts() {
        return this.products;
    }

    public Comments getComments() {
        return this.comments;
    }

    public Entitlements getEntitlements() {
        return this.entitlements;
    }

    public Problems getProblems() {
        return this.problems;
    }

    public Attachments getAttachments() {
        return this.attachments;
    }

    public ConfigHelper getConfigHelper() {
        return this.config;
    }

    public Ping getPing() {
        return this.ping;
    }

    public Groups getGroups() {
        return this.groups;
    }

    public Symptoms getSymptoms() {
        return this.symptoms;
    }
}

