/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.modcluster;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;
import org.rhq.plugins.modcluster.FileConfiguredMBeanResourceComponent;

public class ClassNameMBeanDiscoveryComponent
extends MBeanResourceDiscoveryComponent<JMXComponent<?>> {
    private static final Log log = LogFactory.getLog(FileConfiguredMBeanResourceComponent.class);
    private static final String CLASS_NAME = "className";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent<?>> context, boolean skipUnknownProps) {
        Set results = super.discoverResources(context, skipUnknownProps);
        for (DiscoveredResourceDetails discoveredResource : results) {
            if (this.isBeanConfiguredClassName(context, discoveredResource.getResourceKey())) continue;
            results.remove(discoveredResource);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeanConfiguredClassName(ResourceDiscoveryContext<JMXComponent<?>> context, String objectName) {
        EmsBean emsBean = this.loadBean((JMXComponent)context.getParentResourceComponent(), objectName);
        if (emsBean == null) {
            return false;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(emsBean.getClass().getClassLoader());
            String className = context.getDefaultPluginConfiguration().getSimple(CLASS_NAME).getStringValue();
            boolean bl = className.equals(emsBean.getClassTypeName());
            return bl;
        }
        catch (Exception e) {
            log.info((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

