/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ASTPair;
import antlr.CommonAST;
import antlr.Token;
import antlr.Utils;
import antlr.collections.AST;
import antlr.collections.impl.ASTArray;
import java.lang.reflect.Constructor;
import java.util.Hashtable;

public class ASTFactory {
    protected String theASTNodeType = null;
    protected Class theASTNodeTypeClass = null;
    protected Hashtable tokenTypeToASTClassMap = null;

    public ASTFactory() {
    }

    public ASTFactory(Hashtable tokenTypeToClassMap) {
        this.setTokenTypeToASTClassMap(tokenTypeToClassMap);
    }

    public void setTokenTypeASTNodeType(int tokenType, String className) throws IllegalArgumentException {
        if (this.tokenTypeToASTClassMap == null) {
            this.tokenTypeToASTClassMap = new Hashtable();
        }
        if (className == null) {
            this.tokenTypeToASTClassMap.remove(new Integer(tokenType));
            return;
        }
        Class c = null;
        try {
            c = Utils.loadClass(className);
            this.tokenTypeToASTClassMap.put(new Integer(tokenType), c);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid class, " + className);
        }
    }

    public Class getASTNodeType(int tokenType) {
        Class c;
        if (this.tokenTypeToASTClassMap != null && (c = (Class)this.tokenTypeToASTClassMap.get(new Integer(tokenType))) != null) {
            return c;
        }
        if (this.theASTNodeTypeClass != null) {
            return this.theASTNodeTypeClass;
        }
        return CommonAST.class;
    }

    public void addASTChild(ASTPair currentAST, AST child) {
        if (child != null) {
            if (currentAST.root == null) {
                currentAST.root = child;
            } else if (currentAST.child == null) {
                currentAST.root.setFirstChild(child);
            } else {
                currentAST.child.setNextSibling(child);
            }
            currentAST.child = child;
            currentAST.advanceChildToEnd();
        }
    }

    public AST create() {
        return this.create(0);
    }

    public AST create(int type) {
        Class c = this.getASTNodeType(type);
        AST t = this.create(c);
        if (t != null) {
            t.initialize(type, "");
        }
        return t;
    }

    public AST create(int type, String txt) {
        AST t = this.create(type);
        if (t != null) {
            t.initialize(type, txt);
        }
        return t;
    }

    public AST create(int type, String txt, String className) {
        AST t = this.create(className);
        if (t != null) {
            t.initialize(type, txt);
        }
        return t;
    }

    public AST create(AST tr) {
        if (tr == null) {
            return null;
        }
        AST t = this.create(tr.getType());
        if (t != null) {
            t.initialize(tr);
        }
        return t;
    }

    public AST create(Token tok) {
        AST t = this.create(tok.getType());
        if (t != null) {
            t.initialize(tok);
        }
        return t;
    }

    public AST create(Token tok, String className) {
        AST t = this.createUsingCtor(tok, className);
        return t;
    }

    public AST create(String className) {
        Class c = null;
        try {
            c = Utils.loadClass(className);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid class, " + className);
        }
        return this.create(c);
    }

    protected AST createUsingCtor(Token token, String className) {
        Class c = null;
        AST t = null;
        try {
            c = Utils.loadClass(className);
            Class[] tokenArgType = new Class[]{Token.class};
            try {
                Constructor ctor = c.getConstructor(tokenArgType);
                t = (AST)ctor.newInstance(token);
            }
            catch (NoSuchMethodException e) {
                t = this.create(c);
                if (t != null) {
                    t.initialize(token);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid class or can't make instance, " + className);
        }
        return t;
    }

    protected AST create(Class c) {
        AST t = null;
        try {
            t = (AST)c.newInstance();
        }
        catch (Exception e) {
            this.error("Can't create AST Node " + c.getName());
            return null;
        }
        return t;
    }

    public AST dup(AST t) {
        if (t == null) {
            return null;
        }
        AST dup_t = this.create(t.getClass());
        dup_t.initialize(t);
        return dup_t;
    }

    public AST dupList(AST t) {
        AST result;
        AST nt = result = this.dupTree(t);
        while (t != null) {
            t = t.getNextSibling();
            nt.setNextSibling(this.dupTree(t));
            nt = nt.getNextSibling();
        }
        return result;
    }

    public AST dupTree(AST t) {
        AST result = this.dup(t);
        if (t != null) {
            result.setFirstChild(this.dupList(t.getFirstChild()));
        }
        return result;
    }

    public AST make(AST[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        AST root = nodes[0];
        AST tail = null;
        if (root != null) {
            root.setFirstChild(null);
        }
        for (int i = 1; i < nodes.length; ++i) {
            if (nodes[i] == null) continue;
            if (root == null) {
                root = tail = nodes[i];
            } else if (tail == null) {
                root.setFirstChild(nodes[i]);
                tail = root.getFirstChild();
            } else {
                tail.setNextSibling(nodes[i]);
                tail = tail.getNextSibling();
            }
            while (tail.getNextSibling() != null) {
                tail = tail.getNextSibling();
            }
        }
        return root;
    }

    public AST make(ASTArray nodes) {
        return this.make(nodes.array);
    }

    public void makeASTRoot(ASTPair currentAST, AST root) {
        if (root != null) {
            root.addChild(currentAST.root);
            currentAST.child = currentAST.root;
            currentAST.advanceChildToEnd();
            currentAST.root = root;
        }
    }

    public void setASTNodeClass(Class c) {
        if (c != null) {
            this.theASTNodeTypeClass = c;
            this.theASTNodeType = c.getName();
        }
    }

    public void setASTNodeClass(String t) {
        this.theASTNodeType = t;
        try {
            this.theASTNodeTypeClass = Utils.loadClass(t);
        }
        catch (Exception e) {
            this.error("Can't find/access AST Node type" + t);
        }
    }

    public void setASTNodeType(String t) {
        this.setASTNodeClass(t);
    }

    public Hashtable getTokenTypeToASTClassMap() {
        return this.tokenTypeToASTClassMap;
    }

    public void setTokenTypeToASTClassMap(Hashtable tokenTypeToClassMap) {
        this.tokenTypeToASTClassMap = tokenTypeToClassMap;
    }

    public void error(String e) {
        System.err.println(e);
    }
}

