/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.group.impl;

import java.io.Serializable;
import org.hornetq.api.core.SimpleString;

public final class GroupingHandlerConfiguration
implements Serializable {
    public static final long serialVersionUID = -4600283023652477326L;
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final int DEFAULT_GROUP_TIMEOUT = -1;
    public static final long DEFAULT_REAPER_PERIOD = 30000L;
    public static final String GROUP_TIMEOUT_PROP_NAME = "org.hornetq.GroupingHandlerConfiguration.groupTimeout";
    public static final String REAPER_PERIOD_PROP_NAME = "org.hornetq.GroupingHandlerConfiguration.reaperPeriod";
    private final SimpleString name;
    private final TYPE type;
    private final SimpleString address;
    private final long timeout;
    private long groupTimeout;
    private final long reaperPeriod;

    public GroupingHandlerConfiguration(SimpleString name, TYPE type, SimpleString address) {
        this(name, type, address, 5000, -1L, 30000L);
    }

    public GroupingHandlerConfiguration(SimpleString name, TYPE type, SimpleString address, int timeout) {
        this(name, type, address, timeout, -1L, 30000L);
    }

    public GroupingHandlerConfiguration(SimpleString name, TYPE type, SimpleString address, int timeout, long groupTimeout, long reaperPeriod) {
        this.type = type;
        this.name = name;
        this.address = address;
        this.timeout = timeout;
        this.groupTimeout = System.getProperty(GROUP_TIMEOUT_PROP_NAME) != null ? Long.parseLong(System.getProperty(GROUP_TIMEOUT_PROP_NAME)) : groupTimeout;
        this.reaperPeriod = System.getProperty(REAPER_PERIOD_PROP_NAME) != null ? Long.parseLong(System.getProperty(REAPER_PERIOD_PROP_NAME)) : reaperPeriod;
    }

    public SimpleString getName() {
        return this.name;
    }

    public TYPE getType() {
        return this.type;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getGroupTimeout() {
        return this.groupTimeout;
    }

    public long getReaperPeriod() {
        return this.reaperPeriod;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupingHandlerConfiguration other = (GroupingHandlerConfiguration)obj;
        if (this.address == null ? other.address != null : !this.address.equals((Object)other.address)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals((Object)other.name)) {
            return false;
        }
        if (this.timeout != other.timeout) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum TYPE {
        LOCAL("LOCAL"),
        REMOTE("REMOTE");

        private String type;

        private TYPE(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

