/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.extension.requesthandler;

import com.redhat.gss.extension.RedhatAccessPluginExtension;
import com.redhat.gss.extension.requesthandler.BaseRequestHandler;
import com.redhat.gss.redhat_support_lib.api.API;
import com.redhat.gss.redhat_support_lib.parsers.ExtractedSymptom;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SymptomsFileRequestHandler
extends BaseRequestHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "symptoms";
    public static final SymptomsFileRequestHandler INSTANCE = new SymptomsFileRequestHandler();
    private static final SimpleAttributeDefinition SYMPTIONSFILE = new SimpleAttributeDefinitionBuilder("symptoms-file", ModelType.STRING).build();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("symptoms", (ResourceDescriptionResolver)RedhatAccessPluginExtension.getResourceDescriptionResolver(new String[0])).setParameters(SymptomsFileRequestHandler.getParameters(new AttributeDefinition[]{SYMPTIONSFILE})).setReplyType(ModelType.LIST).setReplyParameters(new AttributeDefinition[]{new SimpleAttributeDefinitionBuilder("summary", ModelType.STRING).build(), new SimpleAttributeDefinitionBuilder("category", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("verbatim", ModelType.STRING, true).build()}).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                API api = SymptomsFileRequestHandler.this.getAPI(context, operation);
                String symptomsFileString = SYMPTIONSFILE.resolveModelAttribute(context, operation).asString();
                List symptoms = null;
                try {
                    symptoms = api.getSymptoms().retrieveSymptoms(symptomsFileString);
                }
                catch (Exception e) {
                    throw new OperationFailedException(e.getLocalizedMessage(), (Throwable)e);
                }
                ModelNode response = context.getResult();
                int i = 0;
                for (ExtractedSymptom symptom : symptoms) {
                    if (symptom.getSummary() == null) continue;
                    ModelNode symptomNode = response.get(i);
                    symptomNode.get("summary").set(symptom.getSummary());
                    if (symptom.getCategory() != null) {
                        symptomNode.get("category").set(symptom.getCategory());
                    }
                    if (symptom.getVerbatim() != null) {
                        symptomNode.get("verbatim").set(symptom.getVerbatim());
                    }
                    ++i;
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

