/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.extension.requesthandler;

import com.redhat.gss.extension.RedhatAccessPluginExtension;
import com.redhat.gss.extension.requesthandler.BaseRequestHandler;
import com.redhat.gss.redhat_support_lib.api.API;
import com.redhat.gss.redhat_support_lib.parsers.Solution;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SearchSolutionsRequestHandler
extends BaseRequestHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "search-solutions";
    public static final SearchSolutionsRequestHandler INSTANCE = new SearchSolutionsRequestHandler();
    private static final SimpleAttributeDefinition SEARCHSTRING = new SimpleAttributeDefinitionBuilder("searchString", ModelType.STRING).build();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("search-solutions", (ResourceDescriptionResolver)RedhatAccessPluginExtension.getResourceDescriptionResolver(new String[0])).setParameters(SearchSolutionsRequestHandler.getParameters(new AttributeDefinition[]{SEARCHSTRING})).setReplyType(ModelType.LIST).setReplyParameters(new AttributeDefinition[]{new SimpleAttributeDefinitionBuilder("id", ModelType.STRING).build(), new SimpleAttributeDefinitionBuilder("title", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("view-uri", ModelType.STRING, true).build()}).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                API api = SearchSolutionsRequestHandler.this.getAPI(context, operation);
                String[] searchStr = new String[]{SEARCHSTRING.resolveModelAttribute(context, operation).asString()};
                List solutions = null;
                try {
                    solutions = api.getSolutions().list(searchStr, null);
                }
                catch (Exception e) {
                    throw new OperationFailedException(e.getLocalizedMessage(), (Throwable)e);
                }
                ModelNode response = context.getResult();
                int i = 0;
                for (Solution solution : solutions) {
                    if (solution.getId() == null) continue;
                    ModelNode solutionNode = response.get(i);
                    solutionNode.get("id").set(solution.getId());
                    if (solution.getTitle() != null) {
                        solutionNode.get("title").set(solution.getTitle());
                    }
                    ++i;
                    if (solution.getViewUri() == null) continue;
                    solutionNode.get("view-uri").set(solution.getViewUri());
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

