/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.extension.requesthandler;

import com.redhat.gss.extension.RedhatAccessPluginExtension;
import com.redhat.gss.extension.requesthandler.BaseRequestHandler;
import com.redhat.gss.redhat_support_lib.api.API;
import com.redhat.gss.redhat_support_lib.parsers.Case;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ModifyCaseRequestHandler
extends BaseRequestHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "modify-case";
    public static final ModifyCaseRequestHandler INSTANCE = new ModifyCaseRequestHandler();
    private static final SimpleAttributeDefinition SUMMARY = new SimpleAttributeDefinitionBuilder("summary", ModelType.STRING, true).build();
    private static final SimpleAttributeDefinition DESCRIPTION = new SimpleAttributeDefinitionBuilder("description", ModelType.STRING, true).build();
    private static final SimpleAttributeDefinition SEVERITY = new SimpleAttributeDefinitionBuilder("severity", ModelType.STRING, true).build();
    private static final SimpleAttributeDefinition PRODUCT = new SimpleAttributeDefinitionBuilder("product", ModelType.STRING, true).build();
    private static final SimpleAttributeDefinition VERSION = new SimpleAttributeDefinitionBuilder("version", ModelType.STRING, true).build();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("modify-case", (ResourceDescriptionResolver)RedhatAccessPluginExtension.getResourceDescriptionResolver(new String[0])).setParameters(ModifyCaseRequestHandler.getParameters(new AttributeDefinition[]{CASENUMBER, SUMMARY, DESCRIPTION, SEVERITY, PRODUCT, VERSION})).setReplyType(ModelType.OBJECT).setReplyParameters(new AttributeDefinition[]{new SimpleAttributeDefinitionBuilder("case-number", ModelType.STRING).build(), new SimpleAttributeDefinitionBuilder("summary", ModelType.STRING).build(), new SimpleAttributeDefinitionBuilder("description", ModelType.STRING).build(), new SimpleAttributeDefinitionBuilder("product", ModelType.STRING).build(), new SimpleAttributeDefinitionBuilder("version", ModelType.STRING).build(), new SimpleAttributeDefinitionBuilder("severity", ModelType.STRING, true).build()}).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                API api = ModifyCaseRequestHandler.this.getAPI(context, operation);
                Case cas = null;
                String caseNumString = BaseRequestHandler.CASENUMBER.resolveModelAttribute(context, operation).asString();
                try {
                    cas = api.getCases().get(caseNumString);
                }
                catch (Exception e) {
                    throw new OperationFailedException(e.getLocalizedMessage(), (Throwable)e);
                }
                if (SUMMARY.resolveModelAttribute(context, operation).isDefined()) {
                    cas.setSummary(SUMMARY.resolveModelAttribute(context, operation).asString());
                }
                if (DESCRIPTION.resolveModelAttribute(context, operation).isDefined()) {
                    cas.setDescription(DESCRIPTION.resolveModelAttribute(context, operation).asString());
                }
                if (SEVERITY.resolveModelAttribute(context, operation).isDefined()) {
                    cas.setSeverity(SEVERITY.resolveModelAttribute(context, operation).asString());
                }
                if (PRODUCT.resolveModelAttribute(context, operation).isDefined()) {
                    cas.setProduct(PRODUCT.resolveModelAttribute(context, operation).asString());
                }
                if (VERSION.resolveModelAttribute(context, operation).isDefined()) {
                    cas.setVersion(VERSION.resolveModelAttribute(context, operation).asString());
                }
                try {
                    cas = api.getCases().update(cas);
                }
                catch (Exception e) {
                    throw new OperationFailedException(e.getLocalizedMessage(), (Throwable)e);
                }
                ModelNode response = context.getResult();
                response.get("case-number").set(cas.getCaseNumber());
                response.get("summary").set(cas.getSummary());
                response.get("description").set(cas.getDescription());
                response.get("product").set(cas.getProduct());
                response.get("version").set(cas.getVersion());
                if (cas.getSeverity() != null) {
                    response.get("severity").set(cas.getSeverity());
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

