/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.extension.requesthandler;

import com.redhat.gss.extension.RedhatAccessPluginExtension;
import com.redhat.gss.extension.requesthandler.BaseRequestHandler;
import com.redhat.gss.redhat_support_lib.api.API;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class GetVersionsRequestHandler
extends BaseRequestHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "get-versions";
    public static final GetVersionsRequestHandler INSTANCE = new GetVersionsRequestHandler();
    private static final SimpleAttributeDefinition PRODUCT = new SimpleAttributeDefinitionBuilder("product", ModelType.STRING).build();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("get-versions", (ResourceDescriptionResolver)RedhatAccessPluginExtension.getResourceDescriptionResolver(new String[0])).setParameters(GetVersionsRequestHandler.getParameters(new AttributeDefinition[]{PRODUCT})).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                API api = GetVersionsRequestHandler.this.getAPI(context, operation);
                String productString = PRODUCT.resolveModelAttribute(context, operation).asString();
                List versions = null;
                try {
                    versions = api.getProducts().getVersions(productString);
                }
                catch (Exception e) {
                    throw new OperationFailedException(e.getLocalizedMessage(), (Throwable)e);
                }
                ModelNode response = context.getResult();
                int i = 0;
                for (String version : versions) {
                    if (version == null) continue;
                    response.get(i).set(version);
                    ++i;
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

