/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.extension.requesthandler;

import com.redhat.gss.extension.RedhatAccessPluginExtension;
import com.redhat.gss.extension.requesthandler.BaseRequestHandler;
import com.redhat.gss.redhat_support_lib.api.API;
import com.redhat.gss.redhat_support_lib.parsers.Solution;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class GetSolutionRequestHandler
extends BaseRequestHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "get-solution";
    public static final GetSolutionRequestHandler INSTANCE = new GetSolutionRequestHandler();
    private static final SimpleAttributeDefinition SOLUTIONID = new SimpleAttributeDefinitionBuilder("solution-id", ModelType.STRING).build();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("get-solution", (ResourceDescriptionResolver)RedhatAccessPluginExtension.getResourceDescriptionResolver(new String[0])).setParameters(GetSolutionRequestHandler.getParameters(new AttributeDefinition[]{SOLUTIONID})).setReplyType(ModelType.OBJECT).setReplyParameters(new AttributeDefinition[]{new SimpleAttributeDefinitionBuilder("id", ModelType.STRING).build(), new SimpleAttributeDefinitionBuilder("title", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("issue", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("environment", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("resolution", ModelType.STRING, true).build()}).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                API api = GetSolutionRequestHandler.this.getAPI(context, operation);
                String solutionIdString = SOLUTIONID.resolveModelAttribute(context, operation).asString();
                Solution solution = null;
                try {
                    solution = api.getSolutions().get(solutionIdString);
                }
                catch (Exception e) {
                    throw new OperationFailedException(e.getLocalizedMessage(), (Throwable)e);
                }
                ModelNode response = context.getResult();
                if (solution.getId() != null) {
                    response.get("id").set(solution.getId());
                    if (solution.getTitle() != null) {
                        response.get("title").set(solution.getTitle());
                    }
                    if (solution.getIssue() != null) {
                        response.get("issue").set(solution.getIssue().getText());
                    }
                    if (solution.getEnvironment() != null) {
                        response.get("environment").set(solution.getEnvironment().getText());
                    }
                    if (solution.getResolution() != null) {
                        response.get("resolution").set(solution.getResolution().getText());
                    }
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

