/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.extension.requesthandler;

import com.redhat.gss.extension.RedhatAccessPluginExtension;
import com.redhat.gss.extension.requesthandler.BaseRequestHandler;
import com.redhat.gss.redhat_support_lib.api.API;
import com.redhat.gss.redhat_support_lib.parsers.Comment;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class GetCommentsRequestHandler
extends BaseRequestHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "get-comments";
    public static final GetCommentsRequestHandler INSTANCE = new GetCommentsRequestHandler();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("get-comments", (ResourceDescriptionResolver)RedhatAccessPluginExtension.getResourceDescriptionResolver(new String[0])).setParameters(GetCommentsRequestHandler.getParameters(new AttributeDefinition[]{CASENUMBER})).setReplyType(ModelType.LIST).setReplyParameters(new AttributeDefinition[]{new SimpleAttributeDefinitionBuilder("author", ModelType.STRING).build(), new SimpleAttributeDefinitionBuilder("date", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("text", ModelType.STRING, true).build()}).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                API api = GetCommentsRequestHandler.this.getAPI(context, operation);
                String caseNumberString = BaseRequestHandler.CASENUMBER.resolveModelAttribute(context, operation).asString();
                List comments = null;
                try {
                    comments = api.getComments().list(caseNumberString, null, null, null);
                }
                catch (Exception e) {
                    throw new OperationFailedException(e.getLocalizedMessage(), (Throwable)e);
                }
                ModelNode response = context.getResult();
                int i = 0;
                for (Comment comment : comments) {
                    if (comment.getId() == null) continue;
                    ModelNode com = response.get(i);
                    if (comment.getCreatedBy() != null) {
                        com.get("author").set(comment.getCreatedBy());
                    }
                    if (comment.getCreatedDate() != null) {
                        com.get("date").set(comment.getCreatedDate().getTime().toString());
                    }
                    if (comment.getText() != null) {
                        com.get("text").set(comment.getText());
                    }
                    ++i;
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

