/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.extension.requesthandler;

import com.redhat.gss.extension.RedhatAccessPluginExtension;
import com.redhat.gss.extension.requesthandler.BaseRequestHandler;
import com.redhat.gss.redhat_support_lib.api.API;
import com.redhat.gss.redhat_support_lib.parsers.Case;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class GetCaseRequestHandler
extends BaseRequestHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "get-case";
    public static final GetCaseRequestHandler INSTANCE = new GetCaseRequestHandler();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("get-case", (ResourceDescriptionResolver)RedhatAccessPluginExtension.getResourceDescriptionResolver(new String[0])).setParameters(GetCaseRequestHandler.getParameters(new AttributeDefinition[]{CASENUMBER})).setReplyType(ModelType.OBJECT).setReplyParameters(new AttributeDefinition[]{new SimpleAttributeDefinitionBuilder("case-number", ModelType.STRING).build(), new SimpleAttributeDefinitionBuilder("summary", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("case-type", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("severity", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("status", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("alternate-id", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("product", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("owner", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("opened", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("last-updated", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("account-number", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("description", ModelType.STRING, true).build()}).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                API api = GetCaseRequestHandler.this.getAPI(context, operation);
                String caseNumberString = BaseRequestHandler.CASENUMBER.resolveModelAttribute(context, operation).asString();
                Case cas = null;
                try {
                    cas = api.getCases().get(caseNumberString);
                }
                catch (Exception e) {
                    throw new OperationFailedException(e.getLocalizedMessage(), (Throwable)e);
                }
                ModelNode response = context.getResult();
                if (cas.getCaseNumber() != null) {
                    response.get("case-number").set(cas.getCaseNumber());
                    if (cas.getSummary() != null) {
                        response.get("summary").set(cas.getSummary());
                    }
                    if (cas.getType() != null) {
                        response.get("case-type").set(cas.getType());
                    }
                    if (cas.getSeverity() != null) {
                        response.get("severity").set(cas.getSeverity());
                    }
                    if (cas.getStatus() != null) {
                        response.get("status").set(cas.getStatus());
                    }
                    if (cas.getAlternateId() != null) {
                        response.get("alternate-id").set(cas.getAlternateId());
                    }
                    if (cas.getProduct() != null) {
                        response.get("product").set(cas.getProduct());
                    }
                    if (cas.getOwner() != null) {
                        response.get("owner").set(cas.getOwner());
                    }
                    if (cas.getCreatedDate() != null) {
                        response.get("opened").set(cas.getCreatedDate().getTime().toString());
                    }
                    if (cas.getLastModifiedDate() != null) {
                        response.get("last-updated").set(cas.getLastModifiedDate().getTime().toString());
                    }
                    if (cas.getAccountNumber() != null) {
                        response.get("account-number").set(cas.getAccountNumber());
                    }
                    if (cas.getDescription() != null) {
                        response.get("description").set(cas.getDescription());
                    }
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

