/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.extension.requesthandler;

import com.redhat.gss.extension.RedhatAccessPluginExtension;
import com.redhat.gss.extension.requesthandler.BaseRequestHandler;
import com.redhat.gss.redhat_support_lib.api.API;
import com.redhat.gss.redhat_support_lib.parsers.Link;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DiagnoseStringRequestHandler
extends BaseRequestHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "diagnose-string";
    private static final SimpleAttributeDefinition DIAGNOSESTRING = new SimpleAttributeDefinitionBuilder("diagnose-string", ModelType.STRING).build();
    public static final DiagnoseStringRequestHandler INSTANCE = new DiagnoseStringRequestHandler();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("diagnose-string", (ResourceDescriptionResolver)RedhatAccessPluginExtension.getResourceDescriptionResolver(new String[0])).setParameters(DiagnoseStringRequestHandler.getParameters(new AttributeDefinition[]{DIAGNOSESTRING})).setReplyType(ModelType.LIST).setReplyParameters(new AttributeDefinition[]{new SimpleAttributeDefinitionBuilder("id", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("title", ModelType.STRING, true).build(), new SimpleAttributeDefinitionBuilder("uri", ModelType.STRING, true).build()}).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                API api = DiagnoseStringRequestHandler.this.getAPI(context, operation);
                String diagnoseStringString = DIAGNOSESTRING.resolveModelAttribute(context, operation).asString();
                List links = null;
                try {
                    links = api.getProblems().diagnoseStr(diagnoseStringString);
                }
                catch (Exception e) {
                    throw new OperationFailedException(e.getLocalizedMessage(), (Throwable)e);
                }
                ModelNode response = context.getResult();
                int i = 0;
                for (Link link : links) {
                    if (link.getUri() == null) continue;
                    String[] splitUri = link.getUri().split("/");
                    String id = splitUri[splitUri.length - 1];
                    ModelNode solutionNode = response.get(i);
                    solutionNode.get("id").set(id);
                    if (link.getValue() != null) {
                        solutionNode.get("title").set(link.getValue());
                    }
                    solutionNode.get("uri").set(link.getUri());
                    ++i;
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

