/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.extension.requesthandler;

import com.redhat.gss.redhat_support_lib.api.API;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class BaseRequestHandler {
    protected static final SimpleAttributeDefinition USERNAME = new SimpleAttributeDefinitionBuilder("username", ModelType.STRING).build();
    protected static final SimpleAttributeDefinition PASSWORD = new SimpleAttributeDefinitionBuilder("password", ModelType.STRING).build();
    protected static final SimpleAttributeDefinition URL = new SimpleAttributeDefinitionBuilder("url", ModelType.STRING, true).build();
    protected static final SimpleAttributeDefinition PROXYUSER = new SimpleAttributeDefinitionBuilder("proxy-user", ModelType.STRING, true).build();
    protected static final SimpleAttributeDefinition PROXYPASSWORD = new SimpleAttributeDefinitionBuilder("proxy-password", ModelType.STRING, true).build();
    protected static final SimpleAttributeDefinition PROXYURL = new SimpleAttributeDefinitionBuilder("proxy-url", ModelType.STRING, true).build();
    protected static final SimpleAttributeDefinition PROXYPORT = new SimpleAttributeDefinitionBuilder("proxy-port", ModelType.INT, true).build();
    protected static final SimpleAttributeDefinition CASENUMBER = new SimpleAttributeDefinitionBuilder("case-number", ModelType.STRING).build();

    protected static AttributeDefinition[] getParameters(AttributeDefinition ... parameters) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(USERNAME);
        params.add(PASSWORD);
        params.add(URL);
        params.add(PROXYUSER);
        params.add(PROXYPASSWORD);
        params.add(PROXYURL);
        params.add(PROXYPORT);
        params.addAll(Arrays.asList(parameters));
        return params.toArray(new AttributeDefinition[params.size()]);
    }

    public API getAPI(OperationContext context, ModelNode operation) throws OperationFailedException {
        String usernameStr = USERNAME.resolveModelAttribute(context, operation).asString();
        String passwordStr = PASSWORD.resolveModelAttribute(context, operation).asString();
        ModelNode urlStr = URL.resolveModelAttribute(context, operation);
        ModelNode proxyUserStr = PROXYUSER.resolveModelAttribute(context, operation);
        ModelNode proxyPasswordStr = PROXYPASSWORD.resolveModelAttribute(context, operation);
        ModelNode proxyUrlStr = PROXYURL.resolveModelAttribute(context, operation);
        ModelNode proxyport = PROXYPORT.resolveModelAttribute(context, operation);
        URL proxyUrlUrl = null;
        if (proxyUrlStr.isDefined()) {
            try {
                proxyUrlUrl = new URL(proxyUrlStr.asString());
            }
            catch (MalformedURLException e) {
                throw new OperationFailedException(e.getLocalizedMessage());
            }
        }
        int proxyPortInt = -1;
        if (proxyport.isDefined()) {
            proxyPortInt = proxyport.asInt();
        }
        API api = null;
        api = urlStr.isDefined() && !urlStr.asString().equals("http://api.access.redhat.com") ? new API(usernameStr, passwordStr, urlStr.isDefined() ? urlStr.asString() : null, proxyUserStr.isDefined() ? proxyUserStr.asString() : null, proxyPasswordStr.isDefined() ? proxyPasswordStr.asString() : null, proxyUrlUrl, proxyPortInt, "EAP6.3", true) : new API(usernameStr, passwordStr, urlStr.isDefined() ? urlStr.asString() : null, proxyUserStr.isDefined() ? proxyUserStr.asString() : null, proxyPasswordStr.isDefined() ? proxyPasswordStr.asString() : null, proxyUrlUrl, proxyPortInt, "eap");
        return api;
    }
}

